/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.sql.SQLUtility;
import com.aoindustries.util.StringUtility;
import java.io.PrintWriter;

public final class SortStatistics {
    private long startTime;
    private int currentRecursion;
    private long totalTime;
    private long algorithmSwitches;
    private long gets;
    private long sets;
    private long objectComparisons;
    private long inListComparisons;
    private long swaps;
    private int maxRecursion;

    public SortStatistics() {
        this.reset();
    }

    public void reset() {
        this.startTime = -1L;
        this.currentRecursion = 0;
        this.totalTime = 0L;
        this.algorithmSwitches = 0L;
        this.gets = 0L;
        this.sets = 0L;
        this.objectComparisons = 0L;
        this.inListComparisons = 0L;
        this.swaps = 0L;
        this.maxRecursion = 0;
    }

    public void sortStarting() {
        if (this.startTime != -1L) {
            throw new RuntimeException("sortStarting already called");
        }
        this.startTime = System.currentTimeMillis();
    }

    public void sortEnding() {
        if (this.startTime == -1L) {
            throw new RuntimeException("sortStarting not yet called");
        }
        this.totalTime += System.currentTimeMillis() - this.startTime;
        this.startTime = -1L;
    }

    public void sortRecursing() {
        ++this.currentRecursion;
        if (this.currentRecursion > this.maxRecursion) {
            this.maxRecursion = this.currentRecursion;
        }
    }

    public void sortUnrecursing() {
        --this.currentRecursion;
    }

    public void sortSwitchingAlgorithms() {
        ++this.algorithmSwitches;
    }

    public long getAlgorithmSwitchCount() {
        return this.algorithmSwitches;
    }

    public void sortGetting() {
        ++this.gets;
    }

    public void sortGetting(int increment) {
        this.gets += (long)increment;
    }

    public long getGetCount() {
        return this.gets;
    }

    public void sortSetting() {
        ++this.sets;
    }

    public void sortSetting(int increment) {
        this.sets += (long)increment;
    }

    public long getSetCount() {
        return this.sets;
    }

    public void sortObjectComparing() {
        ++this.objectComparisons;
    }

    public long getObjectComparisons() {
        return this.objectComparisons;
    }

    public void sortInListComparing() {
        ++this.inListComparisons;
    }

    public long getInListComparisons() {
        return this.inListComparisons;
    }

    public void sortSwapping() {
        ++this.swaps;
    }

    public long getSwapCount() {
        return this.swaps;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getMaxRecursion() {
        return this.maxRecursion;
    }

    public void printStats(PrintWriter out) {
        out.print("Total Time...........: ");
        if (this.totalTime > Integer.MAX_VALUE) {
            out.println(StringUtility.getTimeLengthString(this.totalTime));
        } else {
            out.print(SQLUtility.getMilliDecimal((int)this.totalTime));
            out.println(" seconds");
        }
        out.print("Max Recursion........: ");
        out.println(this.maxRecursion);
        out.print("Algorithm Switches...: ");
        out.println(this.algorithmSwitches);
        out.print("Gets.................: ");
        out.println(this.gets);
        out.print("Sets.................: ");
        out.println(this.sets);
        out.print("In-List Swaps........: ");
        out.println(this.swaps);
        out.print("Object Comparisons...: ");
        out.println(this.objectComparisons);
        out.print("In-List Comparisons..: ");
        out.println(this.inListComparisons);
    }
}

