/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.util.sort.BaseComparisonSortAlgorithm;
import com.aoindustries.util.sort.HeapSort;
import com.aoindustries.util.sort.SortStatistics;
import java.util.Comparator;
import java.util.List;

public final class FastQSort
extends BaseComparisonSortAlgorithm<Object> {
    private static final FastQSort instance = new FastQSort();

    public static FastQSort getInstance() {
        return instance;
    }

    private FastQSort() {
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public <T> void sort(List<T> list, Comparator<? super T> comparator, SortStatistics stats) {
        int length;
        if (stats != null) {
            stats.sortStarting();
        }
        if (FastQSort.quickSort(list, 0, (length = list.size()) - 1, comparator, stats, 1, (int)(10.0 * Math.log(length)))) {
            FastQSort.insertionSort(list, 0, length - 1, comparator, stats);
        } else {
            if (stats != null) {
                stats.sortSwitchingAlgorithms();
            }
            HeapSort.heapSort(list, comparator, stats);
        }
        if (stats != null) {
            stats.sortEnding();
        }
    }

    @Override
    public <T> void sort(T[] array, Comparator<? super T> comparator, SortStatistics stats) {
        int length;
        if (stats != null) {
            stats.sortStarting();
        }
        if (FastQSort.quickSort(array, 0, (length = array.length) - 1, comparator, stats, 1, (int)(10.0 * Math.log(length)))) {
            FastQSort.insertionSort(array, 0, length - 1, comparator, stats);
        } else {
            if (stats != null) {
                stats.sortSwitchingAlgorithms();
            }
            HeapSort.heapSort(array, comparator, stats);
        }
        if (stats != null) {
            stats.sortEnding();
        }
    }

    private static <T> boolean quickSort(List<T> list, int l, int r, Comparator<? super T> comparator, SortStatistics stats, int currentRecursion, int maxRecursion) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (FastQSort.compare(list, l, i, comparator, stats) > 0) {
                FastQSort.swap(list, l, i, stats);
            }
            if (FastQSort.compare(list, l, r, comparator, stats) > 0) {
                FastQSort.swap(list, l, r, stats);
            }
            if (FastQSort.compare(list, i, r, comparator, stats) > 0) {
                FastQSort.swap(list, i, r, stats);
            }
            int j = r - 1;
            FastQSort.swap(list, i, j, stats);
            i = l;
            T v = FastQSort.get(list, j, stats);
            while (true) {
                if (FastQSort.compare(FastQSort.get(list, ++i, stats), v, comparator, stats) < 0) {
                    continue;
                }
                while (FastQSort.compare(FastQSort.get(list, --j, stats), v, comparator, stats) > 0) {
                }
                if (j < i) break;
                FastQSort.swap(list, i, j, stats);
            }
            FastQSort.swap(list, i, r - 1, stats);
            int newRecursion = currentRecursion + 1;
            if (newRecursion > maxRecursion) {
                return false;
            }
            if (stats != null) {
                stats.sortRecursing();
            }
            if (!FastQSort.quickSort(list, l, j, comparator, stats, newRecursion, maxRecursion)) {
                return false;
            }
            if (stats != null) {
                stats.sortUnrecursing();
            }
            if (stats != null) {
                stats.sortRecursing();
            }
            if (!FastQSort.quickSort(list, i + 1, r, comparator, stats, newRecursion, maxRecursion)) {
                return false;
            }
            if (stats != null) {
                stats.sortUnrecursing();
            }
        }
        return true;
    }

    private static <T> boolean quickSort(T[] array, int l, int r, Comparator<? super T> comparator, SortStatistics stats, int currentRecursion, int maxRecursion) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (FastQSort.compare(array, l, i, comparator, stats) > 0) {
                FastQSort.swap(array, l, i, stats);
            }
            if (FastQSort.compare(array, l, r, comparator, stats) > 0) {
                FastQSort.swap(array, l, r, stats);
            }
            if (FastQSort.compare(array, i, r, comparator, stats) > 0) {
                FastQSort.swap(array, i, r, stats);
            }
            int j = r - 1;
            FastQSort.swap(array, i, j, stats);
            i = l;
            T v = FastQSort.get(array, j, stats);
            while (true) {
                if (FastQSort.compare(FastQSort.get(array, ++i, stats), v, comparator, stats) < 0) {
                    continue;
                }
                while (FastQSort.compare(FastQSort.get(array, --j, stats), v, comparator, stats) > 0) {
                }
                if (j < i) break;
                FastQSort.swap(array, i, j, stats);
            }
            FastQSort.swap(array, i, r - 1, stats);
            int newRecursion = currentRecursion + 1;
            if (newRecursion > maxRecursion) {
                return false;
            }
            if (stats != null) {
                stats.sortRecursing();
            }
            if (!FastQSort.quickSort(array, l, j, comparator, stats, newRecursion, maxRecursion)) {
                return false;
            }
            if (stats != null) {
                stats.sortUnrecursing();
            }
            if (stats != null) {
                stats.sortRecursing();
            }
            if (!FastQSort.quickSort(array, i + 1, r, comparator, stats, newRecursion, maxRecursion)) {
                return false;
            }
            if (stats != null) {
                stats.sortUnrecursing();
            }
        }
        return true;
    }

    static <T> void insertionSort(List<T> list, int lo0, int hi0, Comparator<? super T> comparator, SortStatistics stats) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            T t;
            int j;
            T v = FastQSort.get(list, i, stats);
            for (j = i; j > lo0 && FastQSort.compare(t = FastQSort.get(list, j - 1, stats), v, comparator, stats) > 0; --j) {
                FastQSort.set(list, j, t, stats);
            }
            FastQSort.set(list, j, v, stats);
        }
    }

    static <T> void insertionSort(T[] array, int lo0, int hi0, Comparator<? super T> comparator, SortStatistics stats) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            T t;
            int j;
            T v = FastQSort.get(array, i, stats);
            for (j = i; j > lo0 && FastQSort.compare(t = FastQSort.get(array, j - 1, stats), v, comparator, stats) > 0; --j) {
                FastQSort.set(array, j, t, stats);
            }
            FastQSort.set(array, j, v, stats);
        }
    }
}

