/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.util.sort.BaseComparisonSortAlgorithm;
import com.aoindustries.util.sort.SortStatistics;
import java.util.Comparator;
import java.util.List;

public final class EQSort
extends BaseComparisonSortAlgorithm<Object> {
    private static final EQSort instance = new EQSort();

    public static EQSort getInstance() {
        return instance;
    }

    private EQSort() {
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public <T> void sort(List<T> list, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        EQSort.sort(list, 0, list.size() - 1, comparator, stats);
        if (stats != null) {
            stats.sortEnding();
        }
    }

    @Override
    public <T> void sort(T[] array, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        EQSort.sort(array, 0, array.length - 1, comparator, stats);
        if (stats != null) {
            stats.sortEnding();
        }
    }

    private static <T> void sort(List<T> list, int lo0, int hi0, Comparator<? super T> comparator, SortStatistics stats) {
        int hi = hi0;
        int lo = lo0;
        if (hi - lo <= 3) {
            if (stats != null) {
                stats.sortRecursing();
            }
            EQSort.brute(list, lo, hi, comparator, stats);
            if (stats != null) {
                stats.sortUnrecursing();
            }
            return;
        }
        T pivot = EQSort.get(list, (lo + hi) / 2, stats);
        EQSort.set(list, (lo + hi) / 2, EQSort.get(list, hi, stats), stats);
        EQSort.set(list, hi, pivot, stats);
        while (lo < hi) {
            while (EQSort.compare(EQSort.get(list, lo, stats), pivot, comparator, stats) <= 0 && lo < hi) {
                ++lo;
            }
            while (EQSort.compare(pivot, EQSort.get(list, hi, stats), comparator, stats) <= 0 && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            EQSort.swap(list, lo, hi, stats);
        }
        EQSort.set(list, hi0, EQSort.get(list, hi, stats), stats);
        EQSort.set(list, hi, pivot, stats);
        if (stats != null) {
            stats.sortRecursing();
        }
        EQSort.sort(list, lo0, lo - 1, comparator, stats);
        if (stats != null) {
            stats.sortUnrecursing();
        }
        if (stats != null) {
            stats.sortRecursing();
        }
        EQSort.sort(list, hi + 1, hi0, comparator, stats);
        if (stats != null) {
            stats.sortUnrecursing();
        }
    }

    private static <T> void sort(T[] array, int lo0, int hi0, Comparator<? super T> comparator, SortStatistics stats) {
        int hi = hi0;
        int lo = lo0;
        if (hi - lo <= 3) {
            if (stats != null) {
                stats.sortRecursing();
            }
            EQSort.brute(array, lo, hi, comparator, stats);
            if (stats != null) {
                stats.sortUnrecursing();
            }
            return;
        }
        T pivot = EQSort.get(array, (lo + hi) / 2, stats);
        EQSort.set(array, (lo + hi) / 2, EQSort.get(array, hi, stats), stats);
        EQSort.set(array, hi, pivot, stats);
        while (lo < hi) {
            while (EQSort.compare(EQSort.get(array, lo, stats), pivot, comparator, stats) <= 0 && lo < hi) {
                ++lo;
            }
            while (EQSort.compare(pivot, EQSort.get(array, hi, stats), comparator, stats) <= 0 && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            EQSort.swap(array, lo, hi, stats);
        }
        EQSort.set(array, hi0, EQSort.get(array, hi, stats), stats);
        EQSort.set(array, hi, pivot, stats);
        if (stats != null) {
            stats.sortRecursing();
        }
        EQSort.sort(array, lo0, lo - 1, comparator, stats);
        if (stats != null) {
            stats.sortUnrecursing();
        }
        if (stats != null) {
            stats.sortRecursing();
        }
        EQSort.sort(array, hi + 1, hi0, comparator, stats);
        if (stats != null) {
            stats.sortUnrecursing();
        }
    }

    private static <T> void brute(List<T> list, int lo, int hi, Comparator<? super T> comparator, SortStatistics stats) {
        T Olo;
        T Ohi;
        if (hi - lo == 1 && EQSort.compare(Ohi = EQSort.get(list, hi, stats), Olo = EQSort.get(list, lo, stats), comparator, stats) < 0) {
            EQSort.set(list, lo, Ohi, stats);
            EQSort.set(list, hi, Olo, stats);
        }
        if (hi - lo == 2) {
            T Olo2 = EQSort.get(list, lo, stats);
            int pmin = EQSort.compare(Olo2, EQSort.get(list, lo + 1, stats), comparator, stats) < 0 ? lo : lo + 1;
            int n = pmin = EQSort.compare(EQSort.get(list, pmin, stats), EQSort.get(list, lo + 2, stats), comparator, stats) < 0 ? pmin : lo + 2;
            if (pmin != lo) {
                EQSort.set(list, lo, EQSort.get(list, pmin, stats), stats);
                EQSort.set(list, pmin, Olo2, stats);
            }
            if (stats != null) {
                stats.sortRecursing();
            }
            EQSort.brute(list, lo + 1, hi, comparator, stats);
            if (stats != null) {
                stats.sortUnrecursing();
            }
        }
        if (hi - lo == 3) {
            int pmin = EQSort.compare(EQSort.get(list, lo, stats), EQSort.get(list, lo + 1, stats), comparator, stats) < 0 ? lo : lo + 1;
            pmin = EQSort.compare(EQSort.get(list, pmin, stats), EQSort.get(list, lo + 2, stats), comparator, stats) < 0 ? pmin : lo + 2;
            int n = pmin = EQSort.compare(EQSort.get(list, pmin, stats), EQSort.get(list, lo + 3, stats), comparator, stats) < 0 ? pmin : lo + 3;
            if (pmin != lo) {
                EQSort.swap(list, lo, pmin, stats);
            }
            int pmax = EQSort.compare(EQSort.get(list, hi, stats), EQSort.get(list, hi - 1, stats), comparator, stats) > 0 ? hi : hi - 1;
            int n2 = pmax = EQSort.compare(EQSort.get(list, pmax, stats), EQSort.get(list, hi - 2, stats), comparator, stats) > 0 ? pmax : hi - 2;
            if (pmax != hi) {
                EQSort.swap(list, hi, pmax, stats);
            }
            if (stats != null) {
                stats.sortRecursing();
            }
            EQSort.brute(list, lo + 1, hi - 1, comparator, stats);
            if (stats != null) {
                stats.sortUnrecursing();
            }
        }
    }

    private static <T> void brute(T[] array, int lo, int hi, Comparator<T> comparator, SortStatistics stats) {
        T Olo;
        T Ohi;
        if (hi - lo == 1 && EQSort.compare(Ohi = EQSort.get(array, hi, stats), Olo = EQSort.get(array, lo, stats), comparator, stats) < 0) {
            EQSort.set(array, lo, Ohi, stats);
            EQSort.set(array, hi, Olo, stats);
        }
        if (hi - lo == 2) {
            T Olo2 = EQSort.get(array, lo, stats);
            int pmin = EQSort.compare(Olo2, EQSort.get(array, lo + 1, stats), comparator, stats) < 0 ? lo : lo + 1;
            int n = pmin = EQSort.compare(EQSort.get(array, pmin, stats), EQSort.get(array, lo + 2, stats), comparator, stats) < 0 ? pmin : lo + 2;
            if (pmin != lo) {
                EQSort.set(array, lo, EQSort.get(array, pmin, stats), stats);
                EQSort.set(array, pmin, Olo2, stats);
            }
            if (stats != null) {
                stats.sortRecursing();
            }
            EQSort.brute(array, lo + 1, hi, comparator, stats);
            if (stats != null) {
                stats.sortUnrecursing();
            }
        }
        if (hi - lo == 3) {
            int pmin = EQSort.compare(EQSort.get(array, lo, stats), EQSort.get(array, lo + 1, stats), comparator, stats) < 0 ? lo : lo + 1;
            pmin = EQSort.compare(EQSort.get(array, pmin, stats), EQSort.get(array, lo + 2, stats), comparator, stats) < 0 ? pmin : lo + 2;
            int n = pmin = EQSort.compare(EQSort.get(array, pmin, stats), EQSort.get(array, lo + 3, stats), comparator, stats) < 0 ? pmin : lo + 3;
            if (pmin != lo) {
                EQSort.swap(array, lo, pmin, stats);
            }
            int pmax = EQSort.compare(EQSort.get(array, hi, stats), EQSort.get(array, hi - 1, stats), comparator, stats) > 0 ? hi : hi - 1;
            int n2 = pmax = EQSort.compare(EQSort.get(array, pmax, stats), EQSort.get(array, hi - 2, stats), comparator, stats) > 0 ? pmax : hi - 2;
            if (pmax != hi) {
                EQSort.swap(array, hi, pmax, stats);
            }
            if (stats != null) {
                stats.sortRecursing();
            }
            EQSort.brute(array, lo + 1, hi - 1, comparator, stats);
            if (stats != null) {
                stats.sortUnrecursing();
            }
        }
    }
}

