/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.io.FileList;
import com.aoindustries.util.sort.SortAlgorithm;
import com.aoindustries.util.sort.SortStatistics;
import java.util.List;

abstract class BaseSortAlgorithm<E>
implements SortAlgorithm<E> {
    protected BaseSortAlgorithm() {
    }

    @Override
    public <T extends E> void sort(List<T> list) {
        this.sort(list, null);
    }

    @Override
    public <T extends E> void sort(T[] array) {
        this.sort(array, null);
    }

    @Override
    public abstract <T extends E> void sort(List<T> var1, SortStatistics var2);

    @Override
    public abstract <T extends E> void sort(T[] var1, SortStatistics var2);

    protected static <T> T get(List<T> list, int i, SortStatistics stats) {
        if (stats != null) {
            stats.sortGetting();
        }
        return list.get(i);
    }

    protected static <T> T get(T[] array, int i, SortStatistics stats) {
        if (stats != null) {
            stats.sortGetting();
        }
        return array[i];
    }

    protected static <T> void set(List<T> list, int i, T O, SortStatistics stats) {
        if (stats != null) {
            stats.sortSetting();
        }
        list.set(i, O);
    }

    protected static <T> void set(T[] array, int i, T O, SortStatistics stats) {
        if (stats != null) {
            stats.sortSetting();
        }
        array[i] = O;
    }

    protected static <T> void swap(List<T> list, int i, int j, SortStatistics stats) {
        if (stats != null) {
            stats.sortSwapping();
        }
        if (list instanceof FileList) {
            ((FileList)list).swap(i, j);
        } else {
            T T = list.get(i);
            list.set(i, list.get(j));
            list.set(j, T);
        }
    }

    protected static <T> void swap(T[] array, int i, int j, SortStatistics stats) {
        if (stats != null) {
            stats.sortSwapping();
        }
        T T = array[i];
        array[i] = array[j];
        array[j] = T;
    }
}

