/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.util.sort.BaseSortAlgorithm;
import com.aoindustries.util.sort.ComparisonSortAlgorithm;
import com.aoindustries.util.sort.SortStatistics;
import java.util.Comparator;
import java.util.List;

abstract class BaseComparisonSortAlgorithm<E>
extends BaseSortAlgorithm<E>
implements ComparisonSortAlgorithm<E> {
    protected BaseComparisonSortAlgorithm() {
    }

    @Override
    public <T extends E> void sort(List<T> list) {
        this.sort(list, null, null);
    }

    @Override
    public <T extends E> void sort(T[] array) {
        this.sort(array, null, null);
    }

    @Override
    public <T extends E> void sort(List<T> list, SortStatistics stats) {
        this.sort(list, null, stats);
    }

    @Override
    public <T extends E> void sort(T[] array, SortStatistics stats) {
        this.sort(array, null, stats);
    }

    @Override
    public <T extends E> void sort(List<T> list, Comparator<? super T> comparator) {
        this.sort(list, comparator, null);
    }

    @Override
    public <T extends E> void sort(T[] array, Comparator<? super T> comparator) {
        this.sort(array, comparator, null);
    }

    @Override
    public abstract <T extends E> void sort(List<T> var1, Comparator<? super T> var2, SortStatistics var3);

    @Override
    public abstract <T extends E> void sort(T[] var1, Comparator<? super T> var2, SortStatistics var3);

    protected static <T> int compare(List<T> list, int i, int j, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortInListComparing();
        }
        T O1 = list.get(i);
        T O2 = list.get(j);
        if (O1 == null) {
            if (O2 == null) {
                return 0;
            }
            return -1;
        }
        if (O2 == null) {
            return 1;
        }
        if (comparator != null) {
            return comparator.compare(O1, O2);
        }
        if (O1 instanceof Comparable) {
            Comparable comp1 = (Comparable)O1;
            return comp1.compareTo(O2);
        }
        throw new RuntimeException("Must either provide a Comparator or the objects must be Comparable");
    }

    protected static <T> int compare(T[] array, int i, int j, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortInListComparing();
        }
        T O1 = array[i];
        T O2 = array[j];
        if (O1 == null) {
            if (O2 == null) {
                return 0;
            }
            return -1;
        }
        if (O2 == null) {
            return 1;
        }
        if (comparator != null) {
            return comparator.compare(O1, O2);
        }
        if (O1 instanceof Comparable) {
            Comparable comp1 = (Comparable)O1;
            return comp1.compareTo(O2);
        }
        throw new RuntimeException("Must either provide a Comparator or the objects must be Comparable");
    }

    protected static <T> int compare(T O1, T O2, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortObjectComparing();
        }
        if (O1 == null) {
            if (O2 == null) {
                return 0;
            }
            return -1;
        }
        if (O2 == null) {
            return 1;
        }
        if (comparator != null) {
            return comparator.compare(O1, O2);
        }
        if (O1 instanceof Comparable) {
            Comparable comp1 = (Comparable)O1;
            return comp1.compareTo(O2);
        }
        throw new RuntimeException("Must either provide a Comparator or the objects must be Comparable");
    }
}

