/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.util.sort.BaseComparisonSortAlgorithm;
import com.aoindustries.util.sort.ComparisonSortAlgorithm;
import com.aoindustries.util.sort.FastQSort;
import com.aoindustries.util.sort.JavaSort;
import com.aoindustries.util.sort.SortStatistics;
import java.util.Comparator;
import java.util.List;

public final class AutoSort
extends BaseComparisonSortAlgorithm<Object> {
    private static final int FAST_QSORT_THRESHOLD = 10000;
    private static final AutoSort instance = new AutoSort();

    public static AutoSort getInstance() {
        return instance;
    }

    private AutoSort() {
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public <T> void sort(List<T> list) {
        AutoSort.getRecommendedSortAlgorithm(list).sort(list);
    }

    @Override
    public <T> void sort(T[] array) {
        AutoSort.getRecommendedSortAlgorithm(array).sort(array);
    }

    @Override
    public <T> void sort(List<T> list, SortStatistics stats) {
        AutoSort.getRecommendedSortAlgorithm(list).sort(list, stats);
    }

    @Override
    public <T> void sort(T[] array, SortStatistics stats) {
        AutoSort.getRecommendedSortAlgorithm(array).sort(array, stats);
    }

    @Override
    public <T> void sort(List<T> list, Comparator<? super T> comparator) {
        AutoSort.getRecommendedSortAlgorithm(list).sort(list, comparator);
    }

    @Override
    public <T> void sort(T[] array, Comparator<? super T> comparator) {
        AutoSort.getRecommendedSortAlgorithm(array).sort(array, comparator);
    }

    @Override
    public <T> void sort(List<T> list, Comparator<? super T> comparator, SortStatistics stats) {
        AutoSort.getRecommendedSortAlgorithm(list).sort(list, comparator, stats);
    }

    @Override
    public <T> void sort(T[] array, Comparator<? super T> comparator, SortStatistics stats) {
        AutoSort.getRecommendedSortAlgorithm(array).sort(array, comparator, stats);
    }

    public static <T> ComparisonSortAlgorithm<? super T> getRecommendedSortAlgorithm(List<T> list) {
        if (list.size() >= 10000) {
            return FastQSort.getInstance();
        }
        return JavaSort.getInstance();
    }

    public static <T> ComparisonSortAlgorithm<? super T> getRecommendedSortAlgorithm(T[] array) {
        if (array.length >= 10000) {
            return FastQSort.getInstance();
        }
        return JavaSort.getInstance();
    }
}

