/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.util.persistent.BufferedSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ObjectSerializer<E>
extends BufferedSerializer<E> {
    private final Class<E> type;

    public ObjectSerializer(Class<E> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Class is not Serializable: " + type.getName());
        }
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serialize(E value, ByteArrayOutputStream buffer) throws IOException {
        ObjectOutputStream oout = new ObjectOutputStream(buffer);
        try {
            oout.writeObject(value);
        }
        finally {
            oout.close();
        }
    }

    @Override
    public E deserialize(InputStream in) throws IOException {
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            E e = this.type.cast(oin.readObject());
            return e;
        }
        catch (ClassNotFoundException err) {
            throw new IOException(err);
        }
        catch (ClassCastException err) {
            throw new IOException(err);
        }
        finally {
            oin.close();
        }
    }
}

