/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.FileUtils;
import com.aoindustries.util.persistent.AbstractPersistentBuffer;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.ProtectionLevel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedPersistentBuffer
extends AbstractPersistentBuffer {
    private final File tempFile;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private MappedByteBuffer mappedBuffer;
    private boolean modified;
    private boolean closed;

    public MappedPersistentBuffer() throws IOException {
        super(ProtectionLevel.NONE);
        this.tempFile = File.createTempFile("MappedPersistentBuffer", null);
        this.tempFile.deleteOnExit();
        this.raf = new RandomAccessFile(this.tempFile, "rw");
        this.channel = this.raf.getChannel();
        this.channel.lock(0L, Long.MAX_VALUE, false);
        this.mappedBuffer = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, 0L);
    }

    public MappedPersistentBuffer(String name) throws IOException {
        this(new RandomAccessFile(name, "rw"), ProtectionLevel.BARRIER);
    }

    public MappedPersistentBuffer(String name, ProtectionLevel protectionLevel) throws IOException {
        this(new RandomAccessFile(name, protectionLevel == ProtectionLevel.READ_ONLY ? "r" : "rw"), protectionLevel);
    }

    public MappedPersistentBuffer(File file) throws IOException {
        this(new RandomAccessFile(file, "rw"), ProtectionLevel.BARRIER);
    }

    public MappedPersistentBuffer(File file, ProtectionLevel protectionLevel) throws IOException {
        this(new RandomAccessFile(file, protectionLevel == ProtectionLevel.READ_ONLY ? "r" : "rw"), protectionLevel);
    }

    public MappedPersistentBuffer(RandomAccessFile raf, ProtectionLevel protectionLevel) throws IOException {
        super(protectionLevel);
        this.tempFile = null;
        this.raf = raf;
        this.channel = raf.getChannel();
        this.channel.lock(0L, Long.MAX_VALUE, protectionLevel == ProtectionLevel.READ_ONLY);
        this.mappedBuffer = this.channel.map(protectionLevel == ProtectionLevel.READ_ONLY ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, raf.length());
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.raf.close();
        if (this.tempFile != null && this.tempFile.exists()) {
            FileUtils.delete(this.tempFile);
        }
    }

    @Override
    public long capacity() throws IOException {
        return this.raf.length();
    }

    private static int getIndex(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position<0: " + position);
        }
        if (position > Integer.MAX_VALUE) {
            throw new IOException("position too large for MappedPersistentBuffer: " + position);
        }
        return (int)position;
    }

    @Override
    public void setCapacity(long newLength) throws IOException {
        long oldLength = this.capacity();
        if (oldLength != newLength) {
            if (newLength < oldLength) {
                if (this.modified) {
                    if (this.protectionLevel.compareTo(ProtectionLevel.BARRIER) >= 0) {
                        this.mappedBuffer.force();
                    }
                    this.modified = false;
                }
                this.mappedBuffer = this.channel.map(this.protectionLevel == ProtectionLevel.READ_ONLY ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, newLength);
            }
            this.raf.setLength(newLength);
            if (newLength > oldLength) {
                if (this.modified) {
                    if (this.protectionLevel.compareTo(ProtectionLevel.BARRIER) >= 0) {
                        this.mappedBuffer.force();
                    }
                    this.modified = false;
                }
                this.mappedBuffer = this.channel.map(this.protectionLevel == ProtectionLevel.READ_ONLY ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, newLength);
                this.ensureZeros(oldLength, newLength - oldLength);
            }
        }
    }

    @Override
    public void get(long position, byte[] buff, int off, int len) throws IOException {
        this.mappedBuffer.position(MappedPersistentBuffer.getIndex(position));
        this.mappedBuffer.get(buff, off, len);
    }

    @Override
    public int getSome(long position, byte[] buff, int off, int len) throws IOException {
        this.mappedBuffer.position(MappedPersistentBuffer.getIndex(position));
        this.mappedBuffer.get(buff, off, len);
        return len;
    }

    @Override
    public byte get(long position) throws IOException {
        return this.mappedBuffer.get(MappedPersistentBuffer.getIndex(position));
    }

    @Override
    public void ensureZeros(long position, long len) throws IOException {
        if (len > 0L) {
            int endIndex = MappedPersistentBuffer.getIndex(position + len - 1L);
            if (PersistentCollections.ensureZeros(this.mappedBuffer, MappedPersistentBuffer.getIndex(position), (int)len)) {
                this.modified = true;
            }
        }
    }

    @Override
    public void put(long position, byte value) throws IOException {
        this.mappedBuffer.put(MappedPersistentBuffer.getIndex(position), value);
        this.modified = true;
    }

    @Override
    public void put(long position, byte[] buff, int off, int len) throws IOException {
        this.mappedBuffer.position(MappedPersistentBuffer.getIndex(position));
        this.mappedBuffer.put(buff, off, len);
        this.modified = true;
    }

    @Override
    public void barrier(boolean force) throws IOException {
        if (this.modified) {
            if (this.protectionLevel.compareTo(ProtectionLevel.BARRIER) >= 0) {
                this.mappedBuffer.force();
            }
            this.modified = false;
        }
    }

    @Override
    public boolean getBoolean(long position) throws IOException {
        return this.mappedBuffer.get(MappedPersistentBuffer.getIndex(position)) != 0;
    }

    @Override
    public int getInt(long position) throws IOException {
        return this.mappedBuffer.getInt(MappedPersistentBuffer.getIndex(position));
    }

    @Override
    public long getLong(long position) throws IOException {
        return this.mappedBuffer.getLong(MappedPersistentBuffer.getIndex(position));
    }

    @Override
    public void putInt(long position, int value) throws IOException {
        this.mappedBuffer.putInt(MappedPersistentBuffer.getIndex(position), value);
        this.modified = true;
    }

    @Override
    public void putLong(long position, long value) throws IOException {
        this.mappedBuffer.putLong(MappedPersistentBuffer.getIndex(position), value);
        this.modified = true;
    }
}

