/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LongSerializer
implements Serializer<Long> {
    private final byte[] buffer = new byte[8];

    @Override
    public boolean isFixedSerializedSize() {
        return true;
    }

    @Override
    public long getSerializedSize(Long value) {
        return 8L;
    }

    @Override
    public void serialize(Long value, OutputStream out) throws IOException {
        PersistentCollections.longToBuffer(value, this.buffer);
        out.write(this.buffer, 0, 8);
    }

    @Override
    public Long deserialize(InputStream in) throws IOException {
        IoUtils.readFully(in, this.buffer, 0, 8);
        return PersistentCollections.bufferToLong(this.buffer);
    }
}

