/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.util.WrappedException;
import com.aoindustries.util.persistent.AbstractPersistentBlockBuffer;
import com.aoindustries.util.persistent.PersistentBuffer;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class FixedPersistentBlockBuffer
extends AbstractPersistentBlockBuffer {
    private final long blockSize;
    private final boolean singleBitmap;
    private final long bitmapSize;
    private int modCount;
    private long lowestFreeId = 0L;
    private final SortedSet<Long> knownFreeIds = new TreeSet<Long>();

    public FixedPersistentBlockBuffer(PersistentBuffer pbuffer, long blockSize) throws IOException {
        super(pbuffer);
        if (blockSize <= 0L) {
            throw new IllegalArgumentException("blockSize<=0: " + blockSize);
        }
        this.blockSize = blockSize;
        int numZeros = Long.numberOfLeadingZeros(blockSize);
        if (numZeros <= 3) {
            this.singleBitmap = true;
            this.bitmapSize = 1L;
        } else {
            long smallestPowerOfTwo = 1L << 63 - numZeros;
            if (smallestPowerOfTwo != blockSize) {
                smallestPowerOfTwo <<= 1;
                --numZeros;
            }
            if (numZeros <= 33) {
                this.singleBitmap = true;
                this.bitmapSize = 1L << numZeros - 3;
            } else {
                this.singleBitmap = false;
                this.bitmapSize = blockSize;
            }
        }
    }

    private long getBitMapBitsAddress(long id) {
        if (this.singleBitmap) {
            return id >>> 3;
        }
        long bitsPerBitmap = this.bitmapSize << 3;
        long bitmapNum = id / bitsPerBitmap;
        long bitmapStart = bitmapNum * (this.bitmapSize + this.blockSize * bitsPerBitmap);
        return bitmapStart + (id % bitsPerBitmap >>> 3);
    }

    @Override
    protected long getBlockAddress(long id) {
        if (this.singleBitmap) {
            return this.bitmapSize + id * this.blockSize;
        }
        long bitsPerBitmap = this.bitmapSize << 3;
        long bitmapNum = id / bitsPerBitmap;
        long bitmapStart = bitmapNum * (this.bitmapSize + this.blockSize * bitsPerBitmap);
        return bitmapStart + this.bitmapSize + id % bitsPerBitmap * this.blockSize;
    }

    @Override
    public long allocate(long minimumSize) throws IOException {
        if (minimumSize > this.blockSize) {
            throw new IOException("minimumSize>blockSize: " + minimumSize + ">" + this.blockSize);
        }
        if (!this.knownFreeIds.isEmpty()) {
            Long freeIdL = this.knownFreeIds.first();
            this.knownFreeIds.remove(freeIdL);
            long freeId = freeIdL;
            long bitmapBitsAddress = this.getBitMapBitsAddress(freeId);
            byte bits = this.pbuffer.get(bitmapBitsAddress);
            int bit = 1 << (int)(freeId & 7L);
            ++this.modCount;
            this.pbuffer.put(bitmapBitsAddress, (byte)(bits | bit));
            return freeId;
        }
        long bitmapBitsAddress = this.getBitMapBitsAddress(this.lowestFreeId);
        long capacity = this.pbuffer.capacity();
        while (bitmapBitsAddress < capacity) {
            byte bits = this.pbuffer.get(bitmapBitsAddress);
            if (bits != -1) {
                for (int bit = 1 << (int)(this.lowestFreeId & 7L); bit != 256; bit <<= 1) {
                    if ((bits & bit) == 0) {
                        ++this.modCount;
                        this.pbuffer.put(bitmapBitsAddress, (byte)(bits | bit));
                        return this.lowestFreeId++;
                    }
                    ++this.lowestFreeId;
                }
            } else {
                this.lowestFreeId = (this.lowestFreeId & 0xFFFFFFFFFFFFFFF8L) + 8L;
            }
            bitmapBitsAddress = this.getBitMapBitsAddress(this.lowestFreeId);
        }
        ++this.modCount;
        this.expandCapacity(capacity, bitmapBitsAddress + 1L);
        this.pbuffer.put(bitmapBitsAddress, (byte)1);
        return this.lowestFreeId++;
    }

    @Override
    public void deallocate(long id) throws IOException {
        int bit;
        long bitmapBitsAddress = this.getBitMapBitsAddress(id);
        byte bits = this.pbuffer.get(bitmapBitsAddress);
        if ((bits & (bit = 1 << (int)(id & 7L))) == 0) {
            throw new IllegalStateException("Block already deallocated: " + id);
        }
        this.knownFreeIds.add(id);
        ++this.modCount;
        this.pbuffer.put(bitmapBitsAddress, (byte)(bits ^ bit));
    }

    @Override
    public Iterator<Long> iterateBlockIds() {
        return new Iterator<Long>(){
            private int expectedModCount;
            private long lastId;
            private long nextId;
            {
                this.expectedModCount = FixedPersistentBlockBuffer.this.modCount;
                this.lastId = -1L;
                this.nextId = 0L;
            }

            @Override
            public boolean hasNext() {
                if (this.expectedModCount != FixedPersistentBlockBuffer.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                try {
                    long bitmapBitsAddress = FixedPersistentBlockBuffer.this.getBitMapBitsAddress(this.nextId);
                    long capacity = FixedPersistentBlockBuffer.this.pbuffer.capacity();
                    while (bitmapBitsAddress < capacity) {
                        byte bits = FixedPersistentBlockBuffer.this.pbuffer.get(bitmapBitsAddress);
                        if (bits != 0) {
                            for (int bit = 1 << (int)(this.nextId & 7L); bit != 256; bit <<= 1) {
                                if ((bits & bit) != 0) {
                                    return true;
                                }
                                ++this.nextId;
                            }
                        } else {
                            this.nextId = (this.nextId & 0xFFFFFFFFFFFFFFF8L) + 8L;
                        }
                        bitmapBitsAddress = FixedPersistentBlockBuffer.this.getBitMapBitsAddress(this.nextId);
                    }
                    return false;
                }
                catch (IOException err) {
                    throw new WrappedException(err);
                }
            }

            @Override
            public Long next() {
                if (this.expectedModCount != FixedPersistentBlockBuffer.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                try {
                    long bitmapBitsAddress = FixedPersistentBlockBuffer.this.getBitMapBitsAddress(this.nextId);
                    long capacity = FixedPersistentBlockBuffer.this.pbuffer.capacity();
                    while (bitmapBitsAddress < capacity) {
                        byte bits = FixedPersistentBlockBuffer.this.pbuffer.get(bitmapBitsAddress);
                        if (bits != 0) {
                            for (int bit = 1 << (int)(this.nextId & 7L); bit != 256; bit <<= 1) {
                                if ((bits & bit) != 0) {
                                    this.lastId = this.nextId++;
                                    return this.lastId;
                                }
                                ++this.nextId;
                            }
                        } else {
                            this.nextId = (this.nextId & 0xFFFFFFFFFFFFFFF8L) + 8L;
                        }
                        bitmapBitsAddress = FixedPersistentBlockBuffer.this.getBitMapBitsAddress(this.nextId);
                    }
                    throw new NoSuchElementException();
                }
                catch (IOException err) {
                    throw new WrappedException(err);
                }
            }

            @Override
            public void remove() {
                try {
                    if (this.expectedModCount != FixedPersistentBlockBuffer.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.lastId == -1L) {
                        throw new IllegalStateException();
                    }
                    FixedPersistentBlockBuffer.this.deallocate(this.lastId);
                    ++this.expectedModCount;
                    this.lastId = -1L;
                }
                catch (IOException err) {
                    throw new WrappedException(err);
                }
            }
        };
    }

    @Override
    public long getBlockSize(long id) {
        return this.blockSize;
    }

    protected void expandCapacity(long oldCapacity, long newCapacity) throws IOException {
        long percentCapacity = oldCapacity + (oldCapacity >> 2);
        if (percentCapacity > newCapacity) {
            newCapacity = percentCapacity;
        }
        if ((newCapacity & 0xFFFL) != 0L) {
            newCapacity = (newCapacity & 0xFFFFFFFFFFFFF000L) + 4096L;
        }
        this.pbuffer.setCapacity(newCapacity);
    }

    @Override
    protected void ensureCapacity(long capacity) throws IOException {
        long curCapacity = this.pbuffer.capacity();
        if (curCapacity < capacity) {
            this.expandCapacity(curCapacity, capacity);
        }
    }
}

