/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.logging;

import com.aoindustries.util.logging.ErrorPrinterFormatter;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public abstract class QueuedHandler
extends Handler {
    private final ExecutorService consoleExecutor;
    private final ExecutorService customExecutor;

    protected QueuedHandler(final String consoleExecutorThreadName, final String customExecutorThreadName) {
        this.setFormatter(ErrorPrinterFormatter.getInstance());
        this.consoleExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(consoleExecutorThreadName);
                thread.setDaemon(true);
                thread.setPriority(6);
                return thread;
            }
        });
        this.customExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(customExecutorThreadName);
                thread.setDaemon(true);
                thread.setPriority(4);
                return thread;
            }
        });
    }

    @Override
    public final void publish(final LogRecord record) {
        final Formatter formatter = this.getFormatter();
        final String fullReport = formatter.format(record);
        this.consoleExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    System.err.print(fullReport);
                }
            }
        });
        if (this.useCustomLogging(record)) {
            this.customExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    QueuedHandler.this.doCustomLogging(formatter, record, fullReport);
                }
            });
        }
    }

    @Override
    public void flush() {
        System.err.flush();
    }

    @Override
    public void close() throws SecurityException {
        this.consoleExecutor.shutdown();
        this.customExecutor.shutdown();
        try {
            this.consoleExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
        }
        try {
            this.consoleExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
        }
    }

    protected abstract boolean useCustomLogging(LogRecord var1);

    protected abstract void doCustomLogging(Formatter var1, LogRecord var2, String var3);
}

