/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.logging;

import com.aoindustries.util.ErrorPrinter;
import java.util.ArrayList;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ErrorPrinterFormatter
extends Formatter {
    private static final ErrorPrinterFormatter errorPrinterFormatter = new ErrorPrinterFormatter();

    public static ErrorPrinterFormatter getInstance() {
        return errorPrinterFormatter;
    }

    private ErrorPrinterFormatter() {
    }

    public void format(LogRecord record, Appendable out) {
        String message;
        String sourceMethodName;
        ArrayList<String> extraInfo = new ArrayList<String>(9);
        String loggerName = record.getLoggerName();
        if (loggerName != null) {
            extraInfo.add("record.loggerName=" + loggerName);
        }
        extraInfo.add("record.level=" + record.getLevel());
        extraInfo.add("record.sequenceNumber=" + record.getSequenceNumber());
        String sourceClassName = record.getSourceClassName();
        if (sourceClassName != null) {
            extraInfo.add("record.sourceClassName=" + sourceClassName);
        }
        if ((sourceMethodName = record.getSourceMethodName()) != null) {
            extraInfo.add("record.sourceMethodName=" + sourceMethodName);
        }
        if ((message = record.getMessage()) == null) {
            message = "";
        }
        extraInfo.add("record.message=" + message);
        String formatted = this.formatMessage(record);
        if (formatted == null) {
            formatted = "";
        }
        if (!message.equals(formatted)) {
            extraInfo.add("record.message.formatted=" + formatted);
        }
        extraInfo.add("record.threadID=" + record.getThreadID());
        extraInfo.add("record.millis=" + record.getMillis());
        Throwable thrown = record.getThrown();
        ErrorPrinter.printStackTraces(thrown, out, extraInfo.toArray());
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder buffer = new StringBuilder(1024);
        this.format(record, buffer);
        return buffer.toString();
    }
}

