/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import java.util.Locale;
import java.util.concurrent.Callable;

public final class ThreadLocale {
    static final ThreadLocal<Locale> locale = new ThreadLocal<Locale>(){

        @Override
        protected Locale initialValue() {
            return Locale.getDefault();
        }
    };

    private ThreadLocale() {
    }

    public static Locale get() {
        return locale.get();
    }

    public static void set(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale==null");
        }
        ThreadLocale.locale.set(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V set(Locale locale, Callable<V> callable) throws Exception {
        Locale oldLocale = ThreadLocale.get();
        try {
            ThreadLocale.set(locale);
            V v = callable.call();
            return v;
        }
        finally {
            ThreadLocale.set(oldLocale);
        }
    }
}

