/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import com.aoindustries.io.FastExternalizable;
import com.aoindustries.io.FastObjectInput;
import com.aoindustries.io.FastObjectOutput;
import com.aoindustries.util.i18n.CurrencyComparator;
import com.aoindustries.util.i18n.ThreadLocale;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;

public final class Money
implements FastExternalizable,
ObjectInputValidation,
Comparable<Money> {
    private Currency currency;
    private long value;
    private int scale;
    private static final long serialVersionUID = 2287045704444180509L;

    public Money(Currency currency, BigDecimal value) throws NumberFormatException {
        this.currency = currency;
        try {
            int currencyScale = currency.getDefaultFractionDigits();
            if (currencyScale != -1) {
                value = value.setScale(currencyScale);
            }
            this.scale = value.scale();
            this.value = value.movePointRight(value.scale()).longValueExact();
        }
        catch (ArithmeticException err) {
            NumberFormatException newErr = new NumberFormatException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
        this.validate();
    }

    public Money(Currency currency, long value, int scale) throws NumberFormatException {
        this.currency = currency;
        try {
            int currencyScale = currency.getDefaultFractionDigits();
            if (currencyScale != -1 && currencyScale != scale) {
                value = BigDecimal.valueOf(value, scale).setScale(currencyScale).movePointRight(currencyScale).longValueExact();
                scale = currencyScale;
            }
            this.value = value;
            this.scale = scale;
        }
        catch (ArithmeticException err) {
            NumberFormatException newErr = new NumberFormatException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
        this.validate();
    }

    private void validate() throws NumberFormatException {
        int currencyScale = this.currency.getDefaultFractionDigits();
        if (currencyScale != -1 && currencyScale != this.scale) {
            throw new NumberFormatException("currency.scale!=value.scale: " + currencyScale + "!=" + this.scale);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Money)) {
            return false;
        }
        Money other = (Money)o;
        return this.currency == other.currency && this.value == other.value && this.scale == other.scale;
    }

    public int hashCode() {
        int hash = this.currency.getCurrencyCode().hashCode();
        hash = hash * 31 + (int)this.value;
        hash = hash * 31 + this.scale;
        return hash;
    }

    @Override
    public int compareTo(Money other) {
        int diff = CurrencyComparator.getInstance().compare(this.currency, other.currency);
        if (diff != 0) {
            return diff;
        }
        return this.getValue().compareTo(other.getValue());
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() {
        return BigDecimal.valueOf(this.value, this.scale);
    }

    public long getUnscaledValue() {
        return this.value;
    }

    public int getScale() {
        return this.scale;
    }

    public String toString() {
        return this.currency.getSymbol(ThreadLocale.get()) + this.getValue().toPlainString();
    }

    public Money add(Money augend) throws ArithmeticException {
        if (this.currency != augend.currency) {
            throw new ArithmeticException("currency!=augend.currency: " + this.currency + "!=" + augend.currency);
        }
        return new Money(this.currency, this.getValue().add(augend.getValue()));
    }

    public Money multiply(BigDecimal multiplicand) throws ArithmeticException {
        return this.multiply(multiplicand, RoundingMode.UNNECESSARY);
    }

    public Money multiply(BigDecimal multiplicand, RoundingMode roundingMode) throws ArithmeticException {
        int currencyScale = this.currency.getDefaultFractionDigits();
        if (currencyScale == -1) {
            currencyScale = this.scale;
        }
        return new Money(this.currency, this.getValue().multiply(multiplicand).setScale(currencyScale, roundingMode));
    }

    public Money negate() {
        return new Money(this.currency, this.getValue().negate());
    }

    public Money() {
    }

    @Override
    public long getSerialVersionUID() {
        return 2287045704444180509L;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FastObjectOutput fastOut = FastObjectOutput.wrap(out);
        try {
            fastOut.writeFastUTF(this.currency.getCurrencyCode());
            fastOut.writeLong(this.value);
            fastOut.writeInt(this.scale);
        }
        finally {
            fastOut.unwrap();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.currency != null) {
            throw new IllegalStateException();
        }
        FastObjectInput fastIn = FastObjectInput.wrap(in);
        try {
            this.currency = Currency.getInstance(fastIn.readFastUTF());
            this.value = fastIn.readLong();
            this.scale = fastIn.readInt();
        }
        finally {
            fastIn.unwrap();
        }
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        try {
            this.validate();
        }
        catch (NumberFormatException err) {
            InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
    }
}

