/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.graph;

import com.aoindustries.util.AoCollections;
import com.aoindustries.util.graph.CycleException;
import com.aoindustries.util.graph.Edge;
import com.aoindustries.util.graph.GraphSorter;
import com.aoindustries.util.graph.SymmetricMultiGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TopologicalSorter<V, EX extends Exception>
implements GraphSorter<V, EX> {
    private final SymmetricMultiGraph<V, ?, ? extends EX> graph;
    private final boolean isForward;

    public TopologicalSorter(SymmetricMultiGraph<V, ?, ? extends EX> graph, boolean isForward) {
        this.graph = graph;
        this.isForward = isForward;
    }

    @Override
    public List<V> sortGraph() throws CycleException, EX {
        Set vertices = this.graph.getVertices();
        int size = vertices.size();
        HashSet visited = new HashSet(size * 4 / 3 + 1);
        LinkedHashSet sequence = new LinkedHashSet();
        ArrayList L = new ArrayList(size);
        for (Object n : vertices) {
            if (visited.contains(n) || !(this.isForward ? this.graph.getEdgesTo(n) : this.graph.getEdgesFrom(n)).isEmpty()) continue;
            this.topologicalSortVisit(n, L, visited, sequence);
        }
        return AoCollections.optimalUnmodifiableList(L);
    }

    private void topologicalSortVisit(V n, List<V> L, Set<V> visited, LinkedHashSet<V> sequence) throws CycleException, EX {
        if (visited.add(n)) {
            for (Edge edge : this.isForward ? this.graph.getEdgesFrom(n) : this.graph.getEdgesTo(n)) {
                Object m;
                Object v = m = this.isForward ? edge.getTo() : edge.getFrom();
                if (!sequence.add(m)) {
                    ArrayList<Object> vertices = new ArrayList<Object>();
                    boolean found = false;
                    for (Object seq : sequence) {
                        if (!found && seq.equals(m)) {
                            found = true;
                        }
                        if (!found) continue;
                        vertices.add(seq);
                    }
                    vertices.add(m);
                    throw new CycleException(AoCollections.optimalUnmodifiableList(vertices));
                }
                this.topologicalSortVisit(m, L, visited, sequence);
                sequence.remove(m);
            }
            L.add(n);
        }
    }
}

