/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.graph;

import com.aoindustries.util.graph.GraphException;
import java.util.List;

public class CycleException
extends GraphException {
    private static final long serialVersionUID = 7713106090763335656L;
    private final List<?> vertices;

    private static String getMessage(List<?> vertices) {
        StringBuilder SB = new StringBuilder();
        SB.append("Cycle exists:\n");
        for (Object v : vertices) {
            SB.append("    ").append(v.getClass().getName()).append("(\"").append(v.toString()).append("\")\n");
        }
        return SB.toString();
    }

    CycleException(List<?> vertices) {
        super(CycleException.getMessage(vertices));
        if (vertices.size() < 2) {
            throw new IllegalArgumentException("Cycle must have at least two vertices (could be the same vertex)");
        }
        if (!vertices.get(0).equals(vertices.get(vertices.size() - 1))) {
            throw new IllegalArgumentException("Cycle must start and end on the same vertex");
        }
        this.vertices = vertices;
    }

    public List<?> getVertices() {
        return this.vertices;
    }
}

