/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.lang.LocalizedIllegalArgumentException;
import com.aoindustries.util.ApplicationResources;
import com.aoindustries.util.StringUtility;
import java.io.Serializable;
import java.util.List;

public abstract class WildcardPatternMatcher {
    private static final WildcardPatternMatcher matchNone = new WildcardPatternMatcher(){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isMatch(String paramName) {
            return false;
        }
    };
    private static final WildcardPatternMatcher matchAll = new WildcardPatternMatcher(){

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMatch(String paramName) {
            return true;
        }
    };

    public static WildcardPatternMatcher getMatchNone() {
        return matchNone;
    }

    public static WildcardPatternMatcher getMatchAll() {
        return matchAll;
    }

    public static WildcardPatternMatcher getInstance(String patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return matchNone;
        }
        final List<String> list = StringUtility.splitStringCommaSpace(patterns);
        if (list.isEmpty()) {
            return matchNone;
        }
        if (list.size() == 1 && "*".equals(list.get(0))) {
            return matchAll;
        }
        return new WildcardPatternMatcher(){

            @Override
            public boolean isEmpty() {
                assert (!list.isEmpty()) : "Empty list should have returned matchNone above";
                return false;
            }

            @Override
            public boolean isMatch(String paramName) {
                for (String pattern : list) {
                    int patternLen = pattern.length();
                    if (patternLen <= 0) continue;
                    int firstStar = pattern.indexOf(42);
                    if (firstStar == -1) {
                        if (!paramName.equals(pattern)) continue;
                        return true;
                    }
                    if (patternLen == 1) {
                        return true;
                    }
                    int lastStar = pattern.lastIndexOf(42);
                    if (firstStar != lastStar) {
                        throw new LocalizedIllegalArgumentException(ApplicationResources.accessor, "WildcardPatternMatcher.invalidParameterFilter", new Serializable[]{pattern});
                    }
                    if (firstStar == 0) {
                        int paramNameLen = paramName.length();
                        if (paramNameLen < patternLen - 1 || !paramName.regionMatches(paramNameLen - (patternLen - 1), pattern, 1, patternLen - 1)) continue;
                        return true;
                    }
                    if (lastStar == patternLen - 1) {
                        if (paramName.length() < patternLen - 1 || !paramName.regionMatches(0, pattern, 0, patternLen - 1)) continue;
                        return true;
                    }
                    throw new LocalizedIllegalArgumentException(ApplicationResources.accessor, "WildcardPatternMatcher.invalidParameterFilter", new Serializable[]{pattern});
                }
                return false;
            }
        };
    }

    private WildcardPatternMatcher() {
    }

    public abstract boolean isEmpty();

    public abstract boolean isMatch(String var1);
}

