/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class UnionMethodSet<E>
extends AbstractSet<E> {
    private final Object target;
    private final Class<E> classE;
    private final Map<Class<? extends E>, ? extends List<? extends Method<? extends E>>> methodsByClass;

    public UnionMethodSet(Object target, Class<E> classE, Map<Class<? extends E>, ? extends List<? extends Method<? extends E>>> methodsByClass) {
        this.target = target;
        this.classE = classE;
        this.methodsByClass = methodsByClass;
    }

    @Override
    public int size() {
        throw new RuntimeException("TODO: Implement method with similar results as iterator()");
    }

    @Override
    public boolean isEmpty() {
        for (List<Method<E>> methods : this.methodsByClass.values()) {
            for (Method<E> method : methods) {
                E singleton = method.getSingleton(this.target);
                if (singleton != null) {
                    return false;
                }
                Set<E> set = method.getSet(this.target);
                if (set == null || set.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(Object element) {
        if (element == null) {
            return false;
        }
        Class<?> clazz = element.getClass();
        do {
            List<Method<E>> methods;
            if ((methods = this.methodsByClass.get(clazz)) == null) continue;
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                if (!methods.get(i).contains(this.target, element)) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != this.classE && clazz != null);
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<? extends List<? extends Method<? extends E>>> classIter = this.methodsByClass.values().iterator();
        return new Iterator<E>(){
            private List<? extends Method<? extends E>> methods;
            private int methodsSize = 0;
            private int methodIndex = Integer.MAX_VALUE;
            private Set<? extends E> currentSet;
            private List<Set<? extends E>> previousSets;
            private E currentSingleton;
            private List<E> previousSingletons;
            private Iterator<? extends E> valIter;
            private E nextElement;

            private void prepareNextValue() {
                block0: while (this.nextElement == null && classIter.hasNext()) {
                    if (this.valIter != null) {
                        this.nextElement = this.valIter.next();
                        if (!this.valIter.hasNext()) {
                            this.valIter = null;
                        }
                    } else {
                        if (this.currentSingleton != null) {
                            if (this.previousSingletons == null) {
                                this.previousSingletons = new ArrayList();
                            }
                            this.previousSingletons.add(this.currentSingleton);
                            this.currentSingleton = null;
                        }
                        if (this.currentSet != null) {
                            if (this.previousSets == null) {
                                this.previousSets = new ArrayList();
                            }
                            this.previousSets.add(this.currentSet);
                            this.currentSet = null;
                        }
                        while (this.methodIndex >= this.methodsSize) {
                            if (!classIter.hasNext()) {
                                return;
                            }
                            this.methods = (List)classIter.next();
                            this.methodsSize = this.methods.size();
                            this.methodIndex = 0;
                            if (this.previousSets != null) {
                                this.previousSets.clear();
                            }
                            if (this.previousSingletons == null) continue;
                            this.previousSingletons.clear();
                        }
                        Method method = this.methods.get(this.methodIndex++);
                        this.nextElement = method.getSingleton(UnionMethodSet.this.target);
                        if (this.nextElement != null) {
                            this.currentSingleton = this.nextElement;
                            this.valIter = null;
                        } else {
                            Set set = method.getSet(UnionMethodSet.this.target);
                            if (set != null) {
                                this.valIter = set.iterator();
                                if (this.valIter.hasNext()) {
                                    this.currentSet = set;
                                    this.nextElement = this.valIter.next();
                                    if (!this.valIter.hasNext()) {
                                        this.valIter = null;
                                    }
                                } else {
                                    this.nextElement = null;
                                    this.valIter = null;
                                }
                            } else {
                                this.valIter = null;
                            }
                        }
                    }
                    if (this.nextElement == null) continue;
                    if (this.previousSingletons != null && this.previousSingletons.contains(this.nextElement)) {
                        this.nextElement = null;
                        continue;
                    }
                    if (this.previousSets == null) continue;
                    int size = this.previousSets.size();
                    for (int i = 0; i < size; ++i) {
                        if (!this.previousSets.get(i).contains(this.nextElement)) continue;
                        this.nextElement = null;
                        continue block0;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                this.prepareNextValue();
                return this.nextElement != null;
            }

            @Override
            public E next() {
                this.prepareNextValue();
                Object element = this.nextElement;
                if (element == null) {
                    throw new NoSuchElementException();
                }
                this.nextElement = null;
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class SetMethod<E>
    extends ReflectionMethod<E> {
        public SetMethod(Class<?> targetClass, String methodName) throws NoSuchMethodException {
            super(targetClass, methodName);
        }

        public SetMethod(java.lang.reflect.Method method) {
            super(method);
        }

        @Override
        public boolean contains(Object target, Object element) {
            Set<E> set = this.getSet(target);
            return set != null && set.contains(element);
        }

        @Override
        public E getSingleton(Object target) {
            return null;
        }

        @Override
        public Set<? extends E> getSet(Object target) {
            try {
                return (Set)this.method.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(target + "." + this.method + "()", exc);
            }
            catch (InvocationTargetException exc) {
                throw new RuntimeException(target + "." + this.method + "()", exc);
            }
        }
    }

    public static class SingletonMethod<E>
    extends ReflectionMethod<E> {
        public SingletonMethod(Class<?> targetClass, String methodName) throws NoSuchMethodException {
            super(targetClass, methodName);
        }

        public SingletonMethod(java.lang.reflect.Method method) {
            super(method);
        }

        @Override
        public boolean contains(Object target, Object element) {
            return element.equals(this.getSingleton(target));
        }

        @Override
        public E getSingleton(Object target) {
            try {
                return (E)this.method.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(target + "." + this.method + "()", exc);
            }
            catch (InvocationTargetException exc) {
                throw new RuntimeException(target + "." + this.method + "()", exc);
            }
        }

        @Override
        public Set<? extends E> getSet(Object target) {
            return null;
        }
    }

    public static abstract class ReflectionMethod<E>
    implements Method<E> {
        protected final java.lang.reflect.Method method;

        protected ReflectionMethod(Class<?> targetClass, String methodName) throws NoSuchMethodException {
            this(targetClass.getMethod(methodName, new Class[0]));
        }

        protected ReflectionMethod(java.lang.reflect.Method method) {
            this.method = method;
        }

        public final java.lang.reflect.Method getMethod() {
            return this.method;
        }
    }

    public static interface Method<E> {
        public boolean contains(Object var1, Object var2);

        public E getSingleton(Object var1);

        public Set<? extends E> getSet(Object var1);
    }
}

