/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class UnionClassSet<E>
extends AbstractSet<E> {
    private static final boolean ENABLE_ASSERTIONS = true;
    private int size = 0;
    private final Map<Class<?>, Set<? extends E>> added = new LinkedHashMap();

    public UnionClassSet() {
    }

    public UnionClassSet(Collection<? extends E> c) {
        this.addAll(c);
    }

    public UnionClassSet(Set<? extends E> set) {
        this.addAll(set);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Set<E> set = this.added.get(o.getClass());
        return set == null ? false : set.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<Set<? extends E>> setIter = this.added.values().iterator();
        return new Iterator<E>(){
            private Iterator<? extends E> valIter = null;

            @Override
            public boolean hasNext() {
                if (this.valIter == null) {
                    if (setIter.hasNext()) {
                        this.valIter = ((Set)setIter.next()).iterator();
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public E next() {
                if (this.valIter == null) {
                    if (setIter.hasNext()) {
                        this.valIter = ((Set)setIter.next()).iterator();
                    } else {
                        throw new NoSuchElementException();
                    }
                }
                Object val = this.valIter.next();
                if (!this.valIter.hasNext()) {
                    this.valIter = null;
                }
                return val;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (c instanceof Set) {
            return this.addAll((Set)c);
        }
        throw new UnsupportedOperationException("May only add sets");
    }

    private static boolean allSameClass(Class<?> clazz, Iterator<?> iter) {
        while (iter.hasNext()) {
            if (iter.next().getClass() == clazz) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Set<? extends E> set) {
        int setSize = set.size();
        if (setSize == 0) {
            return false;
        }
        Iterator<E> iter = set.iterator();
        Class<?> clazz = iter.next().getClass();
        assert (UnionClassSet.allSameClass(clazz, iter)) : "Not all objects are of the same exact class";
        if (this.added.containsKey(clazz)) {
            throw new IllegalArgumentException("Set already added for class: " + clazz);
        }
        this.size += setSize;
        this.added.put(clazz, set);
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.added.clear();
    }
}

