/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.util.IntList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.RandomAccess;

public class IntArrayList
extends AbstractList<Integer>
implements IntList,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1988646061548931562L;
    protected transient int[] elementData;
    protected int size;

    public IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new int[initialCapacity];
    }

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(Collection<? extends Number> c) {
        this.size = c.size();
        this.elementData = new int[(int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE)];
        Iterator<? extends Number> iter = c.iterator();
        int pos = 0;
        while (iter.hasNext()) {
            this.elementData[pos++] = iter.next().intValue();
        }
    }

    public IntArrayList(int[] elements) {
        this.size = elements.length;
        this.elementData = new int[(int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE)];
        System.arraycopy(elements, 0, this.elementData, 0, this.size);
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            int[] oldData = this.elementData;
            this.elementData = new int[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null) {
            return false;
        }
        if (elem instanceof Number) {
            return this.contains(((Number)elem).intValue());
        }
        return false;
    }

    @Override
    public boolean contains(int elem) {
        return this.indexOf(elem) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null) {
            return -1;
        }
        if (elem instanceof Number) {
            return this.indexOf(((Number)elem).intValue());
        }
        return -1;
    }

    @Override
    public int indexOf(int elem) {
        for (int i = 0; i < this.size; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            return -1;
        }
        if (elem instanceof Number) {
            return this.lastIndexOf(((Number)elem).intValue());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int elem) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            IntArrayList v = (IntArrayList)super.clone();
            v.elementData = new int[this.size];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        for (int c = 0; c < this.size; ++c) {
            result[c] = this.elementData[c];
        }
        return result;
    }

    @Override
    public int[] toArrayInt() {
        int[] result = new int[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public Integer get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    @Override
    public int getInt(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.set(index, (int)element);
    }

    @Override
    public int set(int index, int element) {
        this.RangeCheck(index);
        int oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean add(Integer o) {
        return this.add((int)o);
    }

    @Override
    public boolean add(int o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = o;
        return true;
    }

    @Override
    public void add(int index, Integer element) {
        this.add(index, (int)element);
    }

    @Override
    public void add(int index, int element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    @Override
    public Integer remove(int index) {
        return this.removeAtIndex(index);
    }

    @Override
    public int removeAtIndex(int index) {
        this.RangeCheck(index);
        ++this.modCount;
        int oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0;
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o != null && o instanceof Number) {
            return this.removeByValue(((Number)o).intValue());
        }
        return false;
    }

    @Override
    public boolean removeByValue(int value) {
        for (int index = 0; index < this.size; ++index) {
            if (value != this.elementData[index]) continue;
            this.fastRemove(index);
            return true;
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = 0;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        Iterator<? extends Integer> iter = c.iterator();
        while (iter.hasNext()) {
            this.elementData[this.size++] = iter.next();
        }
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        Iterator<? extends Integer> iter = c.iterator();
        int pos = index;
        while (iter.hasNext()) {
            this.elementData[pos++] = iter.next();
        }
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = 0;
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeInt(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new int[arrayLength];
        int[] a = this.elementData;
        for (int i = 0; i < this.size; ++i) {
            a[i] = s.readInt();
        }
    }
}

