/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.sql.WrappedSQLException;
import com.aoindustries.util.WrappedException;
import com.aoindustries.util.WrappedExceptions;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.Permission;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ErrorPrinter {
    private static final String EOL = System.getProperty("line.separator");

    private ErrorPrinter() {
    }

    public static void printStackTraces(Throwable T) {
        ErrorPrinter.printStackTraces(T, System.err, null);
    }

    public static void printStackTraces(Throwable T, Object[] extraInfo) {
        ErrorPrinter.printStackTraces(T, System.err, extraInfo);
    }

    public static void printStackTraces(Throwable T, Appendable out) {
        ErrorPrinter.printStackTraces(T, out, null);
    }

    private static void appendln(Appendable out) {
        try {
            out.append(EOL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void append(String S, Appendable out) {
        try {
            out.append(S);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void appendln(String S, Appendable out) {
        try {
            out.append(S);
            out.append(EOL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void append(char ch, Appendable out) {
        try {
            out.append(ch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void append(Object O, Appendable out) {
        ErrorPrinter.append(O == null ? "null" : O.toString(), out);
    }

    private static void appendln(Object O, Appendable out) {
        ErrorPrinter.appendln(O == null ? "null" : O.toString(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTraces(Throwable thrown, Appendable out, Object[] extraInfo) {
        Appendable appendable = out;
        synchronized (appendable) {
            ErrorPrinter.appendln(out);
            ErrorPrinter.appendln("**************************", out);
            ErrorPrinter.appendln("* BEGIN EXCEPTION REPORT *", out);
            ErrorPrinter.appendln("**************************", out);
            ErrorPrinter.appendln(out);
            ErrorPrinter.appendln("    Time ", out);
            ErrorPrinter.append("        ", out);
            try {
                ErrorPrinter.appendln(new Date(System.currentTimeMillis()).toString(), out);
            }
            catch (Exception err) {
                ErrorPrinter.append("Unable to display date: ", out);
                ErrorPrinter.appendln(err.toString(), out);
            }
            if (extraInfo != null && extraInfo.length > 0) {
                ErrorPrinter.appendln("    Extra Information", out);
                for (Object ei : extraInfo) {
                    ErrorPrinter.append("        ", out);
                    ErrorPrinter.appendln(ei, out);
                }
            }
            ErrorPrinter.appendln("    Threading", out);
            Thread thread = Thread.currentThread();
            ErrorPrinter.appendln("        Thread", out);
            ErrorPrinter.append("            ID..........: ", out);
            ErrorPrinter.appendln(Long.toString(thread.getId()), out);
            ErrorPrinter.append("            Name........: ", out);
            ErrorPrinter.appendln(thread.getName(), out);
            ErrorPrinter.append("            Daemon......: ", out);
            ErrorPrinter.appendln(Boolean.toString(thread.isDaemon()), out);
            ErrorPrinter.append("            Class.......: ", out);
            ErrorPrinter.appendln(thread.getClass().getName(), out);
            ErrorPrinter.append("            Priority....: ", out);
            ErrorPrinter.appendln(thread.getPriority(), out);
            try {
                for (ThreadGroup TG = thread.getThreadGroup(); TG != null; TG = TG.getParent()) {
                    String name = TG.getName();
                    String classname = TG.getClass().getName();
                    int maxPriority = TG.getMaxPriority();
                    ErrorPrinter.appendln("        ThreadGroup", out);
                    ErrorPrinter.append("            Name........: ", out);
                    ErrorPrinter.appendln(name, out);
                    ErrorPrinter.append("            Class.......: ", out);
                    ErrorPrinter.appendln(classname, out);
                    ErrorPrinter.append("            Max Priority: ", out);
                    ErrorPrinter.appendln(maxPriority, out);
                }
            }
            catch (SecurityException err) {
                ErrorPrinter.append("Unable to print all Thread Groups: ", out);
                ErrorPrinter.appendln(err.toString(), out);
            }
            ErrorPrinter.appendln("    Exceptions", out);
            if (thrown == null) {
                ErrorPrinter.appendln("        No exceptions", out);
            } else {
                ArrayList<Throwable> closed = new ArrayList<Throwable>();
                closed.add(thrown);
                ErrorPrinter.printThrowables(thrown, out, 8, closed);
            }
            ErrorPrinter.appendln(out);
            ErrorPrinter.appendln("**************************", out);
            ErrorPrinter.appendln("*  END EXCEPTION REPORT  *", out);
            ErrorPrinter.appendln("**************************", out);
            try {
                if (out instanceof Flushable) {
                    ((Flushable)((Object)out)).flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isClosed(Throwable thrown, List<Throwable> closed) {
        for (Throwable T : closed) {
            if (T != thrown) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void printThrowables(Throwable thrown, Appendable out, int indent, List<Throwable> closed) {
        int c;
        StackTraceElement[] stack;
        int n;
        block36: {
            Object[] c22;
            block39: {
                block38: {
                    block37: {
                        void var5_14;
                        void var5_12;
                        for (int c3 = 0; c3 < indent; ++c3) {
                            ErrorPrinter.append(' ', out);
                        }
                        ErrorPrinter.appendln(thrown.getClass().getName(), out);
                        ErrorPrinter.printMessage(out, indent + 4, "Message...........: ", thrown.getMessage());
                        ErrorPrinter.printMessage(out, indent + 4, "Localized Message.: ", thrown.getLocalizedMessage());
                        if (!(thrown instanceof SQLException)) break block37;
                        SQLException sql = (SQLException)thrown;
                        if (sql instanceof WrappedSQLException) {
                            ErrorPrinter.printMessage(out, indent + 4, "SQL Statement.....: ", ((WrappedSQLException)sql).getSqlString());
                        }
                        boolean bl = false;
                        while (var5_12 < indent + 4) {
                            ErrorPrinter.append(' ', out);
                            ++var5_12;
                        }
                        ErrorPrinter.append("SQL Error Code....: ", out);
                        ErrorPrinter.appendln(sql.getErrorCode(), out);
                        boolean bl2 = false;
                        while (var5_14 < indent + 4) {
                            ErrorPrinter.append(' ', out);
                            ++var5_14;
                        }
                        ErrorPrinter.append("SQL State.........: ", out);
                        ErrorPrinter.appendln(sql.getSQLState(), out);
                        break block36;
                    }
                    if (!(thrown instanceof WrappedException)) break block38;
                    WrappedException wrapped = (WrappedException)thrown;
                    Object[] objectArray = wrapped.getExtraInfo();
                    if (objectArray == null || objectArray.length <= 0) break block36;
                    for (int c22 = 0; c22 < indent + 4; ++c22) {
                        ErrorPrinter.append(' ', out);
                    }
                    ErrorPrinter.appendln("Extra Information", out);
                    c22 = objectArray;
                    n = c22.length;
                    break block39;
                }
                if (!(thrown instanceof AccessControlException)) break block36;
                try {
                    int c4;
                    AccessControlException ace = (AccessControlException)thrown;
                    Permission permission = ace.getPermission();
                    for (c4 = 0; c4 < indent + 4; ++c4) {
                        ErrorPrinter.append(' ', out);
                    }
                    ErrorPrinter.append("Permission........: ", out);
                    ErrorPrinter.appendln(permission, out);
                    if (permission != null) {
                        for (c4 = 0; c4 < indent + 4; ++c4) {
                            ErrorPrinter.append(' ', out);
                        }
                        ErrorPrinter.append("Permission Class..: ", out);
                        ErrorPrinter.appendln(permission.getClass().getName(), out);
                        for (c4 = 0; c4 < indent + 4; ++c4) {
                            ErrorPrinter.append(' ', out);
                        }
                        ErrorPrinter.append("Permission Name...: ", out);
                        ErrorPrinter.appendln(permission.getName(), out);
                        for (c4 = 0; c4 < indent + 4; ++c4) {
                            ErrorPrinter.append(' ', out);
                        }
                        ErrorPrinter.append("Permission Actions: ", out);
                        ErrorPrinter.appendln(permission.getActions(), out);
                    }
                    break block36;
                }
                catch (SecurityException err) {
                    ErrorPrinter.appendln("Permission........: Unable to get permission details: ", out);
                    ErrorPrinter.append(err.toString(), out);
                }
                break block36;
            }
            for (int i = 0; i < n; ++i) {
                Object wi = c22[i];
                for (int d = 0; d < indent + 8; ++d) {
                    ErrorPrinter.append(' ', out);
                }
                ErrorPrinter.appendln(wi, out);
            }
        }
        for (int c5 = 0; c5 < indent + 4; ++c5) {
            ErrorPrinter.append(' ', out);
        }
        ErrorPrinter.appendln("Stack Trace", out);
        StackTraceElement[] stackTraceElementArray = stack = thrown.getStackTrace();
        int c6 = stackTraceElementArray.length;
        for (n = 0; n < c6; ++n) {
            StackTraceElement ste = stackTraceElementArray[n];
            for (int d = 0; d < indent + 8; ++d) {
                ErrorPrinter.append(' ', out);
            }
            ErrorPrinter.append("at ", out);
            ErrorPrinter.appendln(ste.toString(), out);
        }
        if (!(thrown instanceof WrappedExceptions)) {
            Throwable throwable = thrown.getCause();
            if (throwable != null && !ErrorPrinter.isClosed(throwable, closed)) {
                closed.add(throwable);
                for (c6 = 0; c6 < indent + 4; ++c6) {
                    ErrorPrinter.append(' ', out);
                }
                ErrorPrinter.appendln("Caused By", out);
                ErrorPrinter.printThrowables(throwable, out, indent + 8, closed);
            }
        } else {
            for (Throwable cause : ((WrappedExceptions)thrown).getCauses()) {
                if (ErrorPrinter.isClosed(cause, closed)) continue;
                closed.add(cause);
                for (int c7 = 0; c7 < indent + 4; ++c7) {
                    ErrorPrinter.append(' ', out);
                }
                ErrorPrinter.appendln("Caused By", out);
                ErrorPrinter.printThrowables(cause, out, indent + 8, closed);
            }
        }
        try {
            Method method;
            Throwable rootCause;
            Class<?> clazz = thrown.getClass();
            if (ErrorPrinter.isSubclass(clazz, "javax.servlet.jsp.JspException") && (rootCause = (Throwable)(method = clazz.getMethod("getRootCause", new Class[0])).invoke((Object)thrown, new Object[0])) != null && !ErrorPrinter.isClosed(rootCause, closed)) {
                closed.add(rootCause);
                for (c = 0; c < indent + 4; ++c) {
                    ErrorPrinter.append(' ', out);
                }
                ErrorPrinter.appendln("Caused By", out);
                ErrorPrinter.printThrowables(rootCause, out, indent + 8, closed);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        try {
            Method method;
            Throwable rootCause;
            Class<?> clazz = thrown.getClass();
            if (ErrorPrinter.isSubclass(clazz, "javax.servlet.ServletException") && (rootCause = (Throwable)(method = clazz.getMethod("getRootCause", new Class[0])).invoke((Object)thrown, new Object[0])) != null && !ErrorPrinter.isClosed(rootCause, closed)) {
                closed.add(rootCause);
                for (c = 0; c < indent + 4; ++c) {
                    ErrorPrinter.append(' ', out);
                }
                ErrorPrinter.appendln("Caused By", out);
                ErrorPrinter.printThrowables(rootCause, out, indent + 8, closed);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (!(thrown instanceof SQLException)) return;
        if (thrown instanceof SQLWarning) {
            SQLWarning sQLWarning = ((SQLWarning)thrown).getNextWarning();
            if (sQLWarning == null) return;
            if (ErrorPrinter.isClosed(sQLWarning, closed)) return;
            closed.add(sQLWarning);
            ErrorPrinter.printThrowables(sQLWarning, out, indent, closed);
            return;
        }
        SQLException sQLException = ((SQLException)thrown).getNextException();
        if (sQLException == null) return;
        if (ErrorPrinter.isClosed(sQLException, closed)) return;
        closed.add(sQLException);
        ErrorPrinter.printThrowables(sQLException, out, indent, closed);
    }

    private static void printMessage(Appendable out, int indent, String label, String message) {
        for (int c = 0; c < indent; ++c) {
            ErrorPrinter.append(' ', out);
        }
        ErrorPrinter.append(label, out);
        if (message == null) {
            ErrorPrinter.appendln("null", out);
        } else {
            message = message.trim();
            int messageLen = message.length();
            for (int c = 0; c < messageLen; ++c) {
                char ch = message.charAt(c);
                if (ch == '\n') {
                    int lineIndent = indent + label.length();
                    ErrorPrinter.appendln(out);
                    for (int d = 0; d < lineIndent; ++d) {
                        ErrorPrinter.append(' ', out);
                    }
                    continue;
                }
                if (ch == '\r') continue;
                ErrorPrinter.append(ch, out);
            }
            ErrorPrinter.appendln(out);
        }
    }

    private static boolean isSubclass(Class<?> clazz, String classname) {
        while (clazz != null) {
            if (clazz.getName().equals(classname)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static String getStackTraces(Throwable T) {
        return ErrorPrinter.getStackTraces(T, null);
    }

    public static String getStackTraces(Throwable thrown, Object[] extraInfo) {
        StringBuilder out = new StringBuilder();
        ErrorPrinter.printStackTraces(thrown, out, extraInfo);
        return out.toString();
    }
}

