/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import java.io.IOException;
import java.util.Calendar;

public class CalendarUtils {
    private CalendarUtils() {
    }

    public static Calendar parseDate(String yyyy_mm_dd) throws IllegalArgumentException {
        if (yyyy_mm_dd == null) {
            return null;
        }
        int pos1 = yyyy_mm_dd.indexOf(45, 1);
        if (pos1 == -1) {
            throw new IllegalArgumentException("Invalid date: " + yyyy_mm_dd);
        }
        int pos2 = yyyy_mm_dd.indexOf(45, pos1 + 1);
        if (pos2 == -1) {
            throw new IllegalArgumentException("Invalid date: " + yyyy_mm_dd);
        }
        int year = Integer.parseInt(yyyy_mm_dd.substring(0, pos1));
        int month = Integer.parseInt(yyyy_mm_dd.substring(pos1 + 1, pos2));
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + yyyy_mm_dd);
        }
        int day = Integer.parseInt(yyyy_mm_dd.substring(pos2 + 1));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        if (day < 1 || day > cal.getActualMaximum(5)) {
            throw new IllegalArgumentException("Invalid day of month: " + yyyy_mm_dd);
        }
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static String formatDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        try {
            StringBuilder result = new StringBuilder(10);
            CalendarUtils.formatDate(cal, result);
            return result.toString();
        }
        catch (IOException e) {
            AssertionError ae = new AssertionError((Object)"IOException should never occur on StringBuilder");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public static void formatDate(Calendar cal, Appendable out) throws IOException {
        out.append(Integer.toString(cal.get(1)));
        out.append('-');
        int month = cal.get(2) + 1;
        if (month < 10) {
            out.append('0');
        }
        out.append(Integer.toString(month));
        out.append('-');
        int day = cal.get(5);
        if (day < 10) {
            out.append('0');
        }
        out.append(Integer.toString(day));
    }

    public static Calendar getToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }
}

