/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.lang.ObjectUtils;
import com.aoindustries.util.EnumerationIterator;
import com.aoindustries.util.MinimalList;
import com.aoindustries.util.UnionMethodSet;
import com.aoindustries.util.UnmodifiableArraySet;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class AoCollections {
    public static final SortedSet<?> EMPTY_SORTED_SET = new EmptySortedSet();
    private static final Class<?>[] unmodifiableCollectionClasses = new Class[]{Collections.unmodifiableCollection(Collections.emptyList()).getClass(), Collections.singletonList(null).getClass(), Collections.unmodifiableList(new ArrayList(0)).getClass(), Collections.unmodifiableList(new LinkedList()).getClass(), Collections.singleton(null).getClass(), Collections.unmodifiableSet(Collections.emptySet()).getClass(), UnionMethodSet.class, UnmodifiableArraySet.class, SingletonSortedSet.class, Collections.unmodifiableSortedSet(AoCollections.emptySortedSet()).getClass()};
    private static final Class<?>[] unmodifiableListClasses = new Class[]{Collections.singletonList(null).getClass(), Collections.unmodifiableList(new ArrayList(0)).getClass(), Collections.unmodifiableList(new LinkedList()).getClass()};
    private static final Class<?>[] unmodifiableSetClasses = new Class[]{Collections.singleton(null).getClass(), Collections.unmodifiableSet(Collections.emptySet()).getClass(), Collections.unmodifiableMap(Collections.emptyMap()).entrySet().getClass(), UnionMethodSet.class, UnmodifiableArraySet.class, SingletonSortedSet.class, Collections.unmodifiableSortedSet(AoCollections.emptySortedSet()).getClass()};
    private static final Class<?>[] unmodifiableSortedSetClasses = new Class[]{SingletonSortedSet.class, Collections.unmodifiableSortedSet(AoCollections.emptySortedSet()).getClass()};
    private static final Class<?>[] unmodifiableMapClasses = new Class[]{Collections.emptyMap().getClass(), Collections.singletonMap(null, null).getClass(), Collections.unmodifiableMap(Collections.emptyMap()).getClass(), Collections.unmodifiableSortedMap(new TreeMap()).getClass()};
    private static final Class<?>[] unmodifiableSortedMapClasses = new Class[]{Collections.unmodifiableSortedMap(new TreeMap()).getClass()};

    private AoCollections() {
    }

    public static final <T> SortedSet<T> emptySortedSet() {
        return EMPTY_SORTED_SET;
    }

    public static <T> SortedSet<T> singletonSortedSet(T o) {
        return new SingletonSortedSet<T>(o);
    }

    public static <T> Collection<T> optimalUnmodifiableCollection(Collection<T> collection) {
        int size = collection.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        Class<?> clazz = collection.getClass();
        int len = unmodifiableCollectionClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableCollectionClasses[i] != clazz) continue;
            return collection;
        }
        if (size == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static <T> Collection<T> unmodifiableCopyCollection(Collection<T> collection) {
        int size = collection.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        return Collections.unmodifiableCollection(new ArrayList<T>(collection));
    }

    public static <T> List<T> optimalUnmodifiableList(List<T> list) {
        int size = list.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        Class<?> clazz = list.getClass();
        int len = unmodifiableListClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableListClasses[i] != clazz) continue;
            return list;
        }
        if (size == 1) {
            return Collections.singletonList(list.get(0));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> unmodifiableCopyList(Collection<T> collection) {
        int size = collection.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public static <T> Set<T> optimalUnmodifiableSet(Set<T> set) {
        int size = set.size();
        if (size == 0) {
            return Collections.emptySet();
        }
        Class<?> clazz = set.getClass();
        int len = unmodifiableSetClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableSetClasses[i] != clazz) continue;
            return set;
        }
        if (size == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> unmodifiableCopySet(Collection<T> collection) {
        int size = collection.size();
        if (size == 0) {
            return Collections.emptySet();
        }
        if (size == 1) {
            return Collections.singleton(collection.iterator().next());
        }
        return Collections.unmodifiableSet(new LinkedHashSet<T>(collection));
    }

    public static <T> SortedSet<T> optimalUnmodifiableSortedSet(SortedSet<T> sortedSet) {
        int size = sortedSet.size();
        if (size == 0) {
            return AoCollections.emptySortedSet();
        }
        Class<?> clazz = sortedSet.getClass();
        int len = unmodifiableSortedSetClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableSortedSetClasses[i] != clazz) continue;
            return sortedSet;
        }
        if (size == 1) {
            return AoCollections.singletonSortedSet(sortedSet.first());
        }
        return Collections.unmodifiableSortedSet(sortedSet);
    }

    public static <T> SortedSet<T> unmodifiableCopySortedSet(Collection<T> collection) {
        int size = collection.size();
        if (size == 0) {
            return AoCollections.emptySortedSet();
        }
        if (size == 1) {
            return AoCollections.singletonSortedSet(collection.iterator().next());
        }
        TreeSet<Object> copy = collection instanceof SortedSet ? new TreeSet((SortedSet)collection) : new TreeSet<T>(collection);
        return Collections.unmodifiableSortedSet(copy);
    }

    public static <K, V> Map<K, V> optimalUnmodifiableMap(Map<K, V> map) {
        int size = map.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        Class<?> clazz = map.getClass();
        int len = unmodifiableMapClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableMapClasses[i] != clazz) continue;
            return map;
        }
        if (size == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> unmodifiableCopyMap(Map<K, V> map) {
        int size = map.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        if (size == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static <K, V> SortedMap<K, V> optimalUnmodifiableSortedMap(SortedMap<K, V> sortedMap) {
        Class<?> clazz = sortedMap.getClass();
        int len = unmodifiableSortedMapClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableSortedMapClasses[i] != clazz) continue;
            return sortedMap;
        }
        return Collections.unmodifiableSortedMap(sortedMap);
    }

    public static <K, V> SortedMap<K, V> unmodifiableCopySortedMap(Map<K, V> map) {
        TreeMap<K, V> copy = map instanceof SortedMap ? new TreeMap((SortedMap)map) : new TreeMap<K, V>(map);
        return Collections.unmodifiableSortedMap(copy);
    }

    public static <E> Iterator<E> emptyIterator() {
        return EmptyIterator.instance;
    }

    public static <E> Iterator<E> singletonIterator(E value) {
        return new SingletonIterator<E>(value);
    }

    public static <E> Iterator<E> unmodifiableIterator(Iterator<E> iter) {
        if (iter instanceof UnmodifiableIterator || iter instanceof EnumerationIterator || iter instanceof SingletonIterator || iter == EmptyIterator.instance) {
            return iter;
        }
        return new UnmodifiableIterator<E>(iter);
    }

    public static <E> PeekIterator<E> peekIterator(Iterator<? extends E> iter) {
        return new PeekIterator<E>(iter);
    }

    public static boolean equals(Collection<?> collection1, Collection<?> collection2) {
        if (collection1 == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        int size = collection1.size();
        if (size != collection2.size()) {
            return false;
        }
        Iterator<?> iter1 = collection1.iterator();
        Iterator<?> iter2 = collection2.iterator();
        int count = 0;
        while (iter1.hasNext() && iter2.hasNext()) {
            if (!ObjectUtils.equals(iter1.next(), iter2.next())) {
                return false;
            }
            ++count;
        }
        if (size != count || iter1.hasNext() || iter2.hasNext()) {
            throw new ConcurrentModificationException();
        }
        return true;
    }

    public static int hashCode(Iterable<?> iterable) {
        int hashCode = 1;
        for (Object e : iterable) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    public static <E, R extends E> List<R> filter(List<E> list, Class<R> clazz) {
        if (list == null) {
            return Collections.emptyList();
        }
        List<R> results = null;
        for (E element : list) {
            if (!clazz.isInstance(element)) continue;
            results = MinimalList.add(results, clazz.cast(element));
        }
        return MinimalList.unmodifiable(results);
    }

    public static class PeekIterator<E>
    implements Iterator<E> {
        private final Iterator<? extends E> iter;
        private E next;

        PeekIterator(Iterator<? extends E> iter) {
            this.iter = iter;
            this.next = iter.hasNext() ? iter.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            E value = this.next;
            if (value == null) {
                throw new NoSuchElementException();
            }
            this.next = this.iter.hasNext() ? this.iter.next() : null;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public E peek() {
            E value = this.next;
            if (value == null) {
                throw new NoSuchElementException();
            }
            return value;
        }
    }

    static class UnmodifiableIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iter;

        UnmodifiableIterator(Iterator<E> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class SingletonIterator<E>
    implements Iterator<E> {
        private final E value;
        private boolean hasNext = true;

        SingletonIterator(E value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class EmptyIterator<E>
    implements Iterator<E> {
        static final EmptyIterator<?> instance = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingletonSortedSet<E>
    extends AbstractSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -6732971044735913580L;
        private final E element;

        SingletonSortedSet(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public E next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSortedSet.this.element;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object o) {
            return ObjectUtils.equals(o, this.element);
        }

        @Override
        public Comparator<? super E> comparator() {
            return null;
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            if (ObjectUtils.equals(this.element, fromElement) && ObjectUtils.equals(this.element, toElement)) {
                return AoCollections.emptySortedSet();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            if (ObjectUtils.equals(this.element, toElement)) {
                return AoCollections.emptySortedSet();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            if (ObjectUtils.equals(this.element, fromElement)) {
                return this;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public E first() {
            return this.element;
        }

        @Override
        public E last() {
            return this.element;
        }
    }

    private static class EmptySortedSet
    extends AbstractSet<Object>
    implements SortedSet<Object>,
    Serializable {
        private static final long serialVersionUID = 5914343416838268017L;

        private EmptySortedSet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        private Object readResolve() {
            return EMPTY_SORTED_SET;
        }

        @Override
        public Comparator<? super Object> comparator() {
            return null;
        }

        @Override
        public SortedSet<Object> subSet(Object fromElement, Object toElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<Object> headSet(Object toElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<Object> tailSet(Object fromElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object first() {
            throw new NoSuchElementException();
        }

        @Override
        public Object last() {
            throw new NoSuchElementException();
        }
    }
}

