/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.time;

import com.aoindustries.time.Instant;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;

public class Duration
implements Comparable<Duration>,
Serializable,
ObjectInputValidation {
    public static final Duration ZERO = new Duration(0L, 0);
    private static final long serialVersionUID = 2L;
    private final long seconds;
    private final int nano;
    private static final long MINIMUM_NANO_DURATION_SECONDS = -9223372036L;
    private static final long MAXIMUM_NANO_DURATION_SECONDS = 9223372035L;

    public static Duration between(Instant startInclusive, Instant endExclusive) {
        long diffSeconds = endExclusive.epochSecond - startInclusive.epochSecond;
        int diffNanos = endExclusive.nano - startInclusive.nano;
        if (diffNanos < 0) {
            --diffSeconds;
            diffNanos += 1000000000;
        }
        return new Duration(diffSeconds, diffNanos);
    }

    public Duration(long seconds, int nano) {
        this.seconds = seconds;
        this.nano = nano;
        this.validate();
    }

    private void validate() throws IllegalArgumentException {
        if (this.nano < 0 || this.nano >= 1000000000) {
            throw new IllegalArgumentException("nanoseconds out of range 0-999999999");
        }
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        try {
            this.validate();
        }
        catch (IllegalArgumentException err) {
            InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
    }

    private Object readResolve() {
        if (this.seconds == 0L && this.nano == 0) {
            return ZERO;
        }
        return this;
    }

    public String toString() {
        return Instant.toString(this.seconds, this.nano);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Duration)) {
            return false;
        }
        return this.equals((Duration)obj);
    }

    public boolean equals(Duration other) {
        return other != null && this.seconds == other.seconds && this.nano == other.nano;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) ^ this.nano;
    }

    @Override
    public int compareTo(Duration other) {
        if (this.seconds < other.seconds) {
            return -1;
        }
        if (this.seconds > other.seconds) {
            return 1;
        }
        if (this.nano < other.nano) {
            return -1;
        }
        if (this.nano > other.nano) {
            return 1;
        }
        return 0;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNano() {
        return this.nano;
    }

    public long toNanos() throws ArithmeticException {
        if (this.seconds < -9223372036L || this.seconds > 9223372035L) {
            throw new ArithmeticException("seconds out of range -9223372036-9223372035");
        }
        return this.seconds * 1000000000L + (long)this.nano;
    }
}

