/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.swing;

import com.aoindustries.swing.ApplicationResources;
import com.aoindustries.util.tree.Node;
import com.aoindustries.util.tree.Tree;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class SynchronizingMutableTreeNode<E>
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 7316928657213073513L;

    public SynchronizingMutableTreeNode() {
    }

    public SynchronizingMutableTreeNode(Object userObject) {
        super(userObject);
    }

    public SynchronizingMutableTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public void synchronize(DefaultTreeModel treeModel, Tree<E> tree) throws IOException, SQLException {
        assert (SwingUtilities.isEventDispatchThread()) : ApplicationResources.accessor.getMessage("assert.notRunningInSwingEventThread");
        this.synchronize(treeModel, tree.getRootNodes());
    }

    public void synchronize(DefaultTreeModel treeModel, List<Node<E>> children) throws IOException, SQLException {
        assert (SwingUtilities.isEventDispatchThread()) : ApplicationResources.accessor.getMessage("assert.notRunningInSwingEventThread");
        if (children == null) {
            while (this.getChildCount() > 0) {
                treeModel.removeNodeFromParent((MutableTreeNode)this.getChildAt(this.getChildCount() - 1));
            }
            if (this.getAllowsChildren()) {
                this.setAllowsChildren(false);
                treeModel.reload(this);
            }
        } else {
            if (!this.getAllowsChildren()) {
                this.setAllowsChildren(true);
                treeModel.reload(this);
            }
            int size = children.size();
            for (int index = 0; index < size; ++index) {
                SynchronizingMutableTreeNode synchronizingNode;
                Node<E> child = children.get(index);
                E value = child.getValue();
                if (index >= this.getChildCount()) {
                    synchronizingNode = new SynchronizingMutableTreeNode(value);
                    treeModel.insertNodeInto(synchronizingNode, this, index);
                } else {
                    synchronizingNode = (SynchronizingMutableTreeNode)this.getChildAt(index);
                    if (!synchronizingNode.getUserObject().equals(value)) {
                        int foundIndex = -1;
                        int count = this.getChildCount();
                        for (int searchIndex = index + 1; searchIndex < count; ++searchIndex) {
                            synchronizingNode = (SynchronizingMutableTreeNode)this.getChildAt(searchIndex);
                            if (!synchronizingNode.getUserObject().equals(value)) continue;
                            foundIndex = searchIndex;
                            break;
                        }
                        if (foundIndex != -1) {
                            for (int removeIndex = foundIndex - 1; removeIndex >= index; --removeIndex) {
                                treeModel.removeNodeFromParent((MutableTreeNode)this.getChildAt(removeIndex));
                            }
                        } else {
                            synchronizingNode = new SynchronizingMutableTreeNode(value);
                            treeModel.insertNodeInto(synchronizingNode, this, index);
                        }
                    }
                }
                synchronizingNode.synchronize(treeModel, child.getChildren());
            }
            while (this.getChildCount() > size) {
                treeModel.removeNodeFromParent((MutableTreeNode)this.getChildAt(this.getChildCount() - 1));
            }
        }
    }
}

