/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.sql;

import com.aoindustries.util.StringUtility;
import java.io.Serializable;

public final class Interval
implements Serializable,
Comparable<Interval> {
    private static final long serialVersionUID = 1L;
    private final long interval;

    public Interval(long seconds) {
        this.interval = seconds;
    }

    public Interval(long minutes, long seconds) {
        this(minutes * 60L + seconds);
    }

    public Interval(long hours, long minutes, long seconds) {
        this(hours * 3600L + minutes * 60L + seconds);
    }

    public long getInterval() {
        return this.interval;
    }

    public String toString() {
        return Interval.toString(this.interval);
    }

    public static String toString(long interval) {
        return StringUtility.getDecimalTimeLengthString(interval * 1000L, false);
    }

    @Override
    public int compareTo(Interval o) {
        if (this.interval < o.interval) {
            return -1;
        }
        if (this.interval > o.interval) {
            return 1;
        }
        return 0;
    }
}

