/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.http;

import com.aoindustries.io.Encoder;
import com.aoindustries.lang.NullArgumentException;
import com.aoindustries.net.UrlUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtil {
    private static final String DEFAULT_REQUEST_ENCODING = "ISO-8859-1";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";

    private ServletUtil() {
    }

    public static String getRequestEncoding(ServletRequest request) {
        String requestEncoding = request.getCharacterEncoding();
        return requestEncoding != null ? requestEncoding : DEFAULT_REQUEST_ENCODING;
    }

    public static String getAbsolutePath(String servletPath, String relativeUrlPath) throws MalformedURLException {
        char firstChar;
        if (!(relativeUrlPath.length() <= 0 || (firstChar = relativeUrlPath.charAt(0)) == '/' || firstChar == '#' || relativeUrlPath.startsWith("http:") || relativeUrlPath.startsWith("https:") || relativeUrlPath.startsWith("file:") || relativeUrlPath.startsWith("mailto:") || relativeUrlPath.startsWith("telnet:") || relativeUrlPath.startsWith("tel:") || relativeUrlPath.startsWith("cid:"))) {
            boolean modified;
            NullArgumentException.checkNotNull(servletPath, "servletPath");
            int slashPos = servletPath.lastIndexOf(47);
            if (slashPos == -1) {
                throw new MalformedURLException("No slash found in servlet path: " + servletPath);
            }
            String newPath = relativeUrlPath;
            int newPathLen = newPath.length();
            int newPathStart = 0;
            do {
                modified = false;
                if (newPathLen >= newPathStart + 2 && newPath.regionMatches(newPathStart, "./", 0, 2)) {
                    newPathStart += 2;
                    modified = true;
                }
                if (newPathLen < newPathStart + 3 || !newPath.regionMatches(newPathStart, "../", 0, 3)) continue;
                if ((slashPos = servletPath.lastIndexOf(47, slashPos - 1)) == -1) {
                    throw new MalformedURLException("Too many ../ in relativeUrlPath: " + relativeUrlPath);
                }
                newPathStart += 3;
                modified = true;
            } while (modified);
            relativeUrlPath = new StringBuilder(slashPos + 1 + (newPathLen - newPathStart)).append(servletPath, 0, slashPos + 1).append(newPath, newPathStart, newPathLen).toString();
        }
        return relativeUrlPath;
    }

    public static String getAbsolutePath(HttpServletRequest request, String path) throws MalformedURLException {
        return ServletUtil.getAbsolutePath(request.getServletPath(), path);
    }

    @Deprecated
    public static URL getResource(ServletContext servletContext, String path) throws MalformedURLException {
        return servletContext.getResource(path);
    }

    @Deprecated
    public static URL getResource(ServletContext servletContext, HttpServletRequest request, String relativeUrlPath) throws MalformedURLException {
        return servletContext.getResource(ServletUtil.getAbsolutePath(request, relativeUrlPath));
    }

    @Deprecated
    public static boolean resourceExists(ServletContext servletContext, String path) throws MalformedURLException {
        return ServletUtil.getResource(servletContext, path) != null;
    }

    @Deprecated
    public static boolean resourceExists(ServletContext servletContext, HttpServletRequest request, String relativeUrlPath) throws MalformedURLException {
        return ServletUtil.getResource(servletContext, request, relativeUrlPath) != null;
    }

    public static boolean isGooglebot(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("User-Agent");
        while (headers.hasMoreElements()) {
            String userAgent = (String)headers.nextElement();
            if (!userAgent.contains("Googlebot")) continue;
            String remoteAddr = request.getRemoteAddr();
            String remoteHost = request.getRemoteHost();
            try {
                InetAddress remoteIp = InetAddress.getByName(remoteAddr);
                if (remoteAddr.equals(remoteHost)) {
                    remoteHost = remoteIp.getCanonicalHostName();
                }
                if (remoteHost.endsWith(".googlebot.com") || remoteHost.endsWith(".googlebot.com.")) {
                    for (InetAddress actualIp : InetAddress.getAllByName(remoteHost)) {
                        System.out.println("DEBUG: ServletUtil: Googlebot verified: userAgent=\"" + userAgent + "\", remoteAddr=\"" + remoteAddr + "\", remoteHost=\"" + remoteHost + "\"");
                        if (!actualIp.equals(remoteIp)) continue;
                        return true;
                    }
                    System.out.println("DEBUG: ServletUtil: Googlebot agent with valid reverse DNS failed forward lookup: userAgent=\"" + userAgent + "\", remoteAddr=\"" + remoteAddr + "\", remoteHost=\"" + remoteHost + "\"");
                }
                System.out.println("DEBUG: ServletUtil: Googlebot agent failed valid reverse DNS lookup: userAgent=\"" + userAgent + "\", remoteAddr=\"" + remoteAddr + "\", remoteHost=\"" + remoteHost + "\"");
            }
            catch (UnknownHostException exception) {
                System.out.println("DEBUG: ServletUtil: Googlebot agent verification failed due to exception: userAgent=\"" + userAgent + "\", remoteAddr=\"" + remoteAddr + "\", remoteHost=\"" + remoteHost + "\", exception=\"" + exception + "\"");
            }
            break;
        }
        return false;
    }

    public static String getAbsoluteURL(HttpServletRequest request, String relPath) {
        try {
            StringBuilder buffer = new StringBuilder();
            ServletUtil.getAbsoluteURL(request, relPath, buffer);
            return buffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void getAbsoluteURL(HttpServletRequest request, String relPath, Appendable out) throws IOException {
        out.append(request.isSecure() ? "https://" : "http://");
        out.append(request.getServerName());
        int port = request.getServerPort();
        if (port != (request.isSecure() ? 443 : 80)) {
            out.append(':').append(Integer.toString(port));
        }
        out.append(request.getContextPath());
        out.append(relPath);
    }

    public static void getAbsoluteURL(HttpServletRequest request, String relPath, Encoder encoder, Appendable out) throws IOException {
        if (encoder == null) {
            ServletUtil.getAbsoluteURL(request, relPath, out);
        } else {
            encoder.append(request.isSecure() ? "https://" : "http://", out);
            encoder.append(request.getServerName(), out);
            int port = request.getServerPort();
            if (port != (request.isSecure() ? 443 : 80)) {
                encoder.append(':', out).append(Integer.toString(port), out);
            }
            encoder.append(request.getContextPath(), out);
            encoder.append(relPath, out);
        }
    }

    public static String getRedirectLocation(HttpServletRequest request, HttpServletResponse response, String servletPath, String href) throws MalformedURLException, UnsupportedEncodingException {
        href = ServletUtil.getAbsolutePath(servletPath, href);
        href = UrlUtils.encodeUrlPath(href, response.getCharacterEncoding());
        if ((href = response.encodeRedirectURL(href)).startsWith("/")) {
            href = ServletUtil.getAbsoluteURL(request, href);
        }
        return href;
    }

    public static void sendRedirect(HttpServletResponse response, String location, int status) throws IllegalStateException, IOException {
        if (response.isCommitted()) {
            throw new IllegalStateException("Unable to redirect: Response already committed");
        }
        response.setHeader("Location", location);
        response.sendError(status);
    }

    public static void sendRedirect(HttpServletRequest request, HttpServletResponse response, String href, int status) throws IllegalStateException, IOException {
        ServletUtil.sendRedirect(response, ServletUtil.getRedirectLocation(request, response, request.getServletPath(), href), status);
    }

    public static String getContextRequestUri(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        String contextPath = request.getContextPath();
        int cpLen = contextPath.length();
        if (cpLen > 0) {
            assert (requestUri.startsWith(contextPath));
            return requestUri.substring(cpLen);
        }
        return requestUri;
    }

    public static Method[] getAllDeclaredMethods(Class<?> stopClass, Class<?> c) {
        if (c.equals(stopClass)) {
            return null;
        }
        Method[] parentMethods = ServletUtil.getAllDeclaredMethods(stopClass, c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (parentMethods != null && parentMethods.length > 0) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
            System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
            thisMethods = allMethods;
        }
        return thisMethods;
    }

    public static <S extends HttpServlet> void doOptions(HttpServletResponse response, Class<S> stopClass, Class<? extends S> thisClass, String doGet, String doPost, String doPut, String doDelete, Class<?>[] paramTypes) {
        boolean ALLOW_GET = false;
        boolean ALLOW_HEAD = false;
        boolean ALLOW_POST = false;
        boolean ALLOW_PUT = false;
        boolean ALLOW_DELETE = false;
        boolean ALLOW_TRACE = true;
        boolean ALLOW_OPTIONS = true;
        for (Method method : ServletUtil.getAllDeclaredMethods(stopClass, thisClass)) {
            if (!Arrays.equals(paramTypes, method.getParameterTypes())) continue;
            String methodName = method.getName();
            if (doGet.equals(methodName)) {
                ALLOW_GET = true;
                ALLOW_HEAD = true;
                continue;
            }
            if (doPost.equals(methodName)) {
                ALLOW_POST = true;
                continue;
            }
            if (doPut.equals(methodName)) {
                ALLOW_PUT = true;
                continue;
            }
            if (!doDelete.equals(methodName)) continue;
            ALLOW_DELETE = true;
        }
        StringBuilder allow = new StringBuilder();
        if (ALLOW_GET) {
            allow.append(METHOD_GET);
        }
        if (ALLOW_HEAD) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append(METHOD_HEAD);
        }
        if (ALLOW_POST) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append(METHOD_POST);
        }
        if (ALLOW_PUT) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append(METHOD_PUT);
        }
        if (ALLOW_DELETE) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append(METHOD_DELETE);
        }
        if (ALLOW_TRACE) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append(METHOD_TRACE);
        }
        if (ALLOW_OPTIONS) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append(METHOD_OPTIONS);
        }
        response.setHeader("Allow", allow.toString());
    }
}

