/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.http;

import com.aoindustries.io.FileUtils;
import com.aoindustries.io.IoUtils;
import com.aoindustries.lang.ObjectUtils;
import com.aoindustries.servlet.ServletContextCache;
import com.aoindustries.servlet.http.ServletUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LastModifiedServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(LastModifiedServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private static final long CACHE_MAX_AGE = 1000L;
    private static final String ENCODING = "UTF-8";
    private static final String CSS_EXTENSION = "css";
    public static final String LAST_MODIFIED_PARAMETER_NAME = "lastModified";
    public static final String LAST_MODIFIED_HEADER_NAME = "X-com-aoindustries-servlet-http-LastModifiedServlet-lastModified";
    private static final String GET_LAST_MODIFIED_CACHE_ATTRIBUTE_NAME = LastModifiedServlet.class.getName() + ".getLastModified.cache";
    private static final Set<String> staticExtensions = new HashSet<String>(Arrays.asList("css", "dia", "jar", "class", "js", "spt", "jsfl", "bmp", "exif", "gif", "ico", "jfif", "jpg", "jpeg", "jpe", "mng", "nitf", "png", "svg", "tif", "tiff", "htm", "html", "xhtml", "mhtml", "pdf", "xml", "rss"));

    public static String encodeLastModified(long lastModified) {
        return Long.toString(lastModified / 1000L, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getCachedLastModified(ServletContext servletContext, HeaderAndPath hap) {
        GetLastModifiedCacheValue cacheValue;
        HashMap<HeaderAndPath, GetLastModifiedCacheValue> cache = (HashMap<HeaderAndPath, GetLastModifiedCacheValue>)servletContext.getAttribute(GET_LAST_MODIFIED_CACHE_ATTRIBUTE_NAME);
        if (cache == null) {
            cache = new HashMap<HeaderAndPath, GetLastModifiedCacheValue>();
            servletContext.setAttribute(GET_LAST_MODIFIED_CACHE_ATTRIBUTE_NAME, cache);
        }
        Object object = cache;
        synchronized (object) {
            cacheValue = (GetLastModifiedCacheValue)cache.get(hap);
            if (cacheValue == null) {
                cacheValue = new GetLastModifiedCacheValue();
                cache.put(hap, cacheValue);
            }
        }
        object = cacheValue;
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            if (cacheValue.isValid(currentTime)) {
                return cacheValue.lastModified;
            }
            ServletContextCache servletContextCache = ServletContextCache.getCache(servletContext);
            long lastModified = 0L;
            String realPath = servletContextCache.getRealPath(hap.path);
            if (realPath != null) {
                lastModified = new File(realPath).lastModified();
            }
            if (lastModified == 0L) {
                try {
                    URL resourceUrl = servletContextCache.getResource(hap.path);
                    if (resourceUrl != null) {
                        URLConnection conn = resourceUrl.openConnection();
                        conn.setAllowUserInteraction(false);
                        conn.setConnectTimeout(10);
                        conn.setDoInput(false);
                        conn.setDoOutput(false);
                        conn.setReadTimeout(10);
                        conn.setUseCaches(false);
                        lastModified = conn.getLastModified();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            cacheValue.cacheTime = currentTime;
            cacheValue.lastModified = lastModified;
            return lastModified;
        }
    }

    public static long getLastModified(ServletContext servletContext, HttpServletRequest request, String path, String extension) {
        HeaderAndPath hap = new HeaderAndPath(request, path);
        if (CSS_EXTENSION.equals(extension)) {
            try {
                return ParsedCssFile.parseCssFile(servletContext, hap).newestLastModified;
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return LastModifiedServlet.getCachedLastModified(servletContext, hap);
    }

    public static long getLastModified(ServletContext servletContext, HttpServletRequest request, String path) {
        return LastModifiedServlet.getLastModified(servletContext, request, path, FileUtils.getExtension(path));
    }

    public static String addLastModified(ServletContext servletContext, HttpServletRequest request, String servletPath, String url, AddLastModifiedWhen when) throws MalformedURLException {
        String resourcePath;
        if (when != AddLastModifiedWhen.FALSE && (resourcePath = ServletUtil.getAbsolutePath(servletPath, url)).startsWith("/")) {
            long lastModified;
            int questionPos = resourcePath.lastIndexOf(63);
            resourcePath = questionPos == -1 ? resourcePath : resourcePath.substring(0, questionPos);
            String extension = FileUtils.getExtension(resourcePath).toLowerCase(Locale.ROOT);
            boolean doAdd = when == AddLastModifiedWhen.TRUE ? true : ("false".equalsIgnoreCase(request.getHeader(LAST_MODIFIED_HEADER_NAME)) ? false : staticExtensions.contains(extension));
            if (doAdd && (lastModified = LastModifiedServlet.getLastModified(servletContext, request, resourcePath, extension)) != 0L) {
                int questionPos2 = url.lastIndexOf(63);
                int anchorStart = url.lastIndexOf(35);
                url = anchorStart == -1 ? url + (questionPos2 == -1 ? (char)'?' : '&') + LAST_MODIFIED_PARAMETER_NAME + "=" + LastModifiedServlet.encodeLastModified(lastModified) : url.substring(0, anchorStart) + (questionPos2 == -1 ? (char)'?' : '&') + LAST_MODIFIED_PARAMETER_NAME + "=" + LastModifiedServlet.encodeLastModified(lastModified) + url.substring(anchorStart);
            }
        }
        return url;
    }

    protected long getLastModified(HttpServletRequest request) {
        long lastModified = LastModifiedServlet.getLastModified(this.getServletContext(), request, request.getServletPath());
        return lastModified == 0L ? -1L : lastModified;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HeaderAndPath hap = new HeaderAndPath(request, request.getServletPath());
            String extension = FileUtils.getExtension(hap.path);
            if (!CSS_EXTENSION.equalsIgnoreCase(extension)) {
                throw new ServletException("Unsupported file type: " + extension);
            }
            byte[] rewrittenCss = ParsedCssFile.parseCssFile(this.getServletContext(), hap).rewrittenCssFile;
            response.setContentType("text/css");
            response.setCharacterEncoding(ENCODING);
            response.setContentLength(rewrittenCss.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(rewrittenCss);
        }
        catch (FileNotFoundException e) {
            response.sendError(404);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, null, e);
            response.sendError(500);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, null, e);
            response.sendError(500);
        }
    }

    public static enum AddLastModifiedWhen {
        TRUE("true"),
        FALSE("false"),
        AUTO("auto");

        private final String lowerName;

        public static AddLastModifiedWhen valueOfLowerName(String lowerName) {
            if ("true" == lowerName) {
                return TRUE;
            }
            if ("false" == lowerName) {
                return FALSE;
            }
            if ("auto" == lowerName) {
                return AUTO;
            }
            if ("true".equals(lowerName)) {
                return TRUE;
            }
            if ("false".equals(lowerName)) {
                return FALSE;
            }
            if ("auto".equals(lowerName)) {
                return AUTO;
            }
            throw new IllegalArgumentException(lowerName);
        }

        private AddLastModifiedWhen(String lowerName) {
            this.lowerName = lowerName;
        }

        public String getLowerName() {
            return this.lowerName;
        }
    }

    private static class GetLastModifiedCacheValue {
        private long cacheTime = Long.MIN_VALUE;
        private long lastModified = Long.MIN_VALUE;

        private GetLastModifiedCacheValue() {
        }

        private boolean isValid(long currentTime) {
            long timeSince = currentTime - this.cacheTime;
            return -1000L <= timeSince && timeSince <= 1000L;
        }
    }

    private static class ParsedCssFile {
        private static final String PARSE_CSS_FILE_CACHE_ATTRIBUTE_NAME = ParsedCssFile.class.getName() + ".parseCssFile.cache";
        private static final Pattern urlPattern = Pattern.compile("url\\s*\\(\\s*['\"]?(\\S+)['\"]?\\s*\\)", 2);
        private final long lastModified;
        private final byte[] rewrittenCssFile;
        private final Map<HeaderAndPath, Long> referencedPaths;
        private final long newestLastModified;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ParsedCssFile parseCssFile(ServletContext servletContext, HeaderAndPath hap) throws FileNotFoundException, IOException {
            HashMap<HeaderAndPath, ParsedCssFile> cache = (HashMap<HeaderAndPath, ParsedCssFile>)servletContext.getAttribute(PARSE_CSS_FILE_CACHE_ATTRIBUTE_NAME);
            if (cache == null) {
                cache = new HashMap<HeaderAndPath, ParsedCssFile>();
                servletContext.setAttribute(PARSE_CSS_FILE_CACHE_ATTRIBUTE_NAME, cache);
            }
            HashMap<HeaderAndPath, ParsedCssFile> hashMap = cache;
            synchronized (hashMap) {
                String cssContent;
                long lastModified = LastModifiedServlet.getCachedLastModified(servletContext, hap);
                ParsedCssFile parsedCssFile = (ParsedCssFile)cache.get(hap);
                if (parsedCssFile != null && parsedCssFile.lastModified == lastModified && !parsedCssFile.hasModifiedUrl(servletContext)) {
                    return parsedCssFile;
                }
                InputStream resourceIn = servletContext.getResourceAsStream(hap.path);
                if (resourceIn == null) {
                    throw new FileNotFoundException(hap.path);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(resourceIn, LastModifiedServlet.ENCODING));
                try {
                    cssContent = IoUtils.readFully(in);
                }
                finally {
                    in.close();
                }
                StringBuilder newContent = new StringBuilder(cssContent.length() << 1);
                HashMap<HeaderAndPath, Long> referencedPaths = new HashMap<HeaderAndPath, Long>();
                Matcher matcher = urlPattern.matcher(cssContent);
                int lastEnd = 0;
                while (matcher.find()) {
                    HeaderAndPath resourceHap;
                    long resourceModified;
                    String resourcePath;
                    int start = matcher.start(1);
                    int end = matcher.end(1);
                    if (start != lastEnd) {
                        newContent.append(cssContent, lastEnd, start);
                    }
                    String url = matcher.group(1);
                    String addAfterUrl = null;
                    if (url.endsWith("'")) {
                        url = url.substring(0, url.length() - 1);
                        addAfterUrl = "'";
                    } else if (url.endsWith("\"")) {
                        url = url.substring(0, url.length() - 1);
                        addAfterUrl = "\"";
                    }
                    newContent.append(url);
                    if ((hap.header == null || hap.header.booleanValue()) && (resourcePath = ServletUtil.getAbsolutePath(hap.path, url)).startsWith("/") && (resourceModified = LastModifiedServlet.getCachedLastModified(servletContext, resourceHap = new HeaderAndPath(hap.header, resourcePath))) != 0L) {
                        referencedPaths.put(resourceHap, resourceModified);
                        int questionPos = url.lastIndexOf(63);
                        newContent.append(questionPos == -1 ? (char)'?' : '&').append(LastModifiedServlet.LAST_MODIFIED_PARAMETER_NAME).append('=').append(LastModifiedServlet.encodeLastModified(resourceModified));
                    }
                    if (addAfterUrl != null) {
                        newContent.append(addAfterUrl);
                    }
                    lastEnd = end;
                }
                if (lastEnd < cssContent.length()) {
                    newContent.append(cssContent, lastEnd, cssContent.length());
                }
                parsedCssFile = new ParsedCssFile(servletContext, lastModified, newContent.toString().getBytes(LastModifiedServlet.ENCODING), referencedPaths);
                cache.put(hap, parsedCssFile);
                return parsedCssFile;
            }
        }

        private ParsedCssFile(ServletContext servletContext, long lastModified, byte[] rewrittenCssFile, Map<HeaderAndPath, Long> referencedPaths) {
            this.lastModified = lastModified;
            this.referencedPaths = referencedPaths;
            this.rewrittenCssFile = rewrittenCssFile;
            long newest = lastModified;
            for (Map.Entry<HeaderAndPath, Long> entry : referencedPaths.entrySet()) {
                long modified = LastModifiedServlet.getCachedLastModified(servletContext, entry.getKey());
                if (modified <= newest) continue;
                newest = modified;
            }
            this.newestLastModified = newest;
        }

        private boolean hasModifiedUrl(ServletContext servletContext) {
            for (Map.Entry<HeaderAndPath, Long> entry : this.referencedPaths.entrySet()) {
                if (LastModifiedServlet.getCachedLastModified(servletContext, entry.getKey()) == entry.getValue()) continue;
                return true;
            }
            return false;
        }
    }

    private static class HeaderAndPath {
        private final Boolean header;
        private final String path;

        private HeaderAndPath(Boolean header, String path) {
            this.header = header;
            this.path = path;
        }

        private HeaderAndPath(HttpServletRequest request, String path) {
            String headerS = request.getHeader(LastModifiedServlet.LAST_MODIFIED_HEADER_NAME);
            this.header = "true".equalsIgnoreCase(headerS) ? Boolean.TRUE : ("false".equalsIgnoreCase(headerS) ? Boolean.FALSE : null);
            this.path = path;
        }

        public String toString() {
            return "(" + this.header + ", " + this.path + ")";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HeaderAndPath)) {
                return false;
            }
            HeaderAndPath other = (HeaderAndPath)obj;
            return ObjectUtils.equals(this.header, other.header) && this.path.equals(other.path);
        }

        public int hashCode() {
            int hash = ObjectUtils.hashCode(this.header);
            hash = hash * 31 + this.path.hashCode();
            return hash;
        }
    }
}

