/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.http;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.SkipPageException;

public class Includer {
    private static final Logger logger = Logger.getLogger(Includer.class.getName());
    private static final String IS_INCLUDED_REQUEST_ATTRIBUTE_NAME = Includer.class.getName() + ".isIncluded";
    private static final String LOCATION_REQUEST_ATTRIBUTE_NAME = Includer.class.getName() + ".location";
    private static final String STATUS_REQUEST_ATTRIBUTE_NAME = Includer.class.getName() + ".sendError.status";
    private static final String MESSAGE_REQUEST_ATTRIBUTE_NAME = Includer.class.getName() + ".sendError.message";
    private static final String PAGE_SKIPPED_REQUEST_ATTRIBUTE_NAME = Includer.class.getName() + ".pageSkipped";

    private Includer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatchInclude(RequestDispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SkipPageException {
        boolean isOutmostInclude;
        boolean bl = isOutmostInclude = request.getAttribute(IS_INCLUDED_REQUEST_ATTRIBUTE_NAME) == null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "request={0}, isOutmostInclude={1}", new Object[]{request, isOutmostInclude});
        }
        try {
            if (isOutmostInclude) {
                request.setAttribute(IS_INCLUDED_REQUEST_ATTRIBUTE_NAME, (Object)true);
            }
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
            if (isOutmostInclude) {
                Integer status;
                String location = (String)request.getAttribute(LOCATION_REQUEST_ATTRIBUTE_NAME);
                if (location != null) {
                    response.setHeader("Location", location);
                }
                if ((status = (Integer)request.getAttribute(STATUS_REQUEST_ATTRIBUTE_NAME)) != null) {
                    String message = (String)request.getAttribute(MESSAGE_REQUEST_ATTRIBUTE_NAME);
                    if (message == null) {
                        response.sendError(status.intValue());
                    } else {
                        response.sendError(status.intValue(), message);
                    }
                }
            }
            if (request.getAttribute(PAGE_SKIPPED_REQUEST_ATTRIBUTE_NAME) != null) {
                throw new SkipPageException();
            }
        }
        finally {
            if (isOutmostInclude) {
                request.removeAttribute(IS_INCLUDED_REQUEST_ATTRIBUTE_NAME);
                request.removeAttribute(LOCATION_REQUEST_ATTRIBUTE_NAME);
                request.removeAttribute(STATUS_REQUEST_ATTRIBUTE_NAME);
                request.removeAttribute(MESSAGE_REQUEST_ATTRIBUTE_NAME);
            }
        }
    }

    public static void setLocation(HttpServletRequest request, HttpServletResponse response, String location) {
        if (request.getAttribute(IS_INCLUDED_REQUEST_ATTRIBUTE_NAME) == null) {
            response.setHeader("Location", location);
        } else {
            request.setAttribute(LOCATION_REQUEST_ATTRIBUTE_NAME, (Object)location);
        }
    }

    public static void sendError(HttpServletRequest request, HttpServletResponse response, int status, String message) throws IOException {
        if (request.getAttribute(IS_INCLUDED_REQUEST_ATTRIBUTE_NAME) == null) {
            if (message == null) {
                response.sendError(status);
            } else {
                response.sendError(status, message);
            }
        } else {
            request.setAttribute(STATUS_REQUEST_ATTRIBUTE_NAME, (Object)status);
            request.setAttribute(MESSAGE_REQUEST_ATTRIBUTE_NAME, (Object)message);
        }
    }

    public static void sendError(HttpServletRequest request, HttpServletResponse response, int status) throws IOException {
        Includer.sendError(request, response, status, null);
    }

    public static void setPageSkipped(ServletRequest request) {
        request.setAttribute(PAGE_SKIPPED_REQUEST_ATTRIBUTE_NAME, (Object)true);
    }
}

