/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.http;

import com.aoindustries.servlet.LocalizedServletException;
import com.aoindustries.servlet.http.ApplicationResources;
import com.aoindustries.servlet.http.Includer;
import com.aoindustries.servlet.http.ServletUtil;
import com.aoindustries.util.AoCollections;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.SkipPageException;

public class Dispatcher {
    private static final Logger logger = Logger.getLogger(Dispatcher.class.getName());
    public static final String ARG_MAP_REQUEST_ATTRIBUTE_NAME = "arg";
    private static final String ORIGINAL_PAGE_REQUEST_ATTRIBUTE = Dispatcher.class.getName() + ".originalPage";
    private static final String DISPATCHED_PAGE_REQUEST_ATTRIBUTE = Dispatcher.class.getName() + ".dispatchedPage";

    private Dispatcher() {
    }

    public static String getOriginalPage(ServletRequest request) {
        return (String)request.getAttribute(ORIGINAL_PAGE_REQUEST_ATTRIBUTE);
    }

    public static void setOriginalPage(ServletRequest request, String page) {
        request.setAttribute(ORIGINAL_PAGE_REQUEST_ATTRIBUTE, (Object)page);
    }

    public static String getOriginalPagePath(HttpServletRequest request) {
        String original = Dispatcher.getOriginalPage((ServletRequest)request);
        return original != null ? original : request.getServletPath();
    }

    public static String getDispatchedPage(ServletRequest request) {
        String dispatchedPage = (String)request.getAttribute(DISPATCHED_PAGE_REQUEST_ATTRIBUTE);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "request={0}, dispatchedPage={1}", new Object[]{request, dispatchedPage});
        }
        return dispatchedPage;
    }

    public static void setDispatchedPage(ServletRequest request, String dispatchedPage) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "request={0}, dispatchedPage={1}", new Object[]{request, dispatchedPage});
        }
        request.setAttribute(DISPATCHED_PAGE_REQUEST_ATTRIBUTE, (Object)dispatchedPage);
    }

    public static String getCurrentPagePath(HttpServletRequest request) {
        String dispatched = Dispatcher.getDispatchedPage((ServletRequest)request);
        if (dispatched != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "request={0}, dispatched={1}", new Object[]{request, dispatched});
            }
            return dispatched;
        }
        String servletPath = request.getServletPath();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "request={0}. servletPath={1}", new Object[]{request, servletPath});
        }
        return servletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forward(ServletContext servletContext, String page, HttpServletRequest request, HttpServletResponse response, Map<String, ?> args) throws ServletException, IOException {
        String contextRelativePath = ServletUtil.getAbsolutePath(Dispatcher.getCurrentPagePath(request), page);
        RequestDispatcher dispatcher = servletContext.getRequestDispatcher(contextRelativePath);
        if (dispatcher == null) {
            throw new LocalizedServletException(ApplicationResources.accessor, "Dispatcher.dispatcherNotFound", new Serializable[]{contextRelativePath});
        }
        String oldOriginal = Dispatcher.getOriginalPage((ServletRequest)request);
        try {
            if (oldOriginal == null) {
                Dispatcher.setOriginalPage((ServletRequest)request, request.getServletPath());
            }
            String oldDispatchPage = Dispatcher.getDispatchedPage((ServletRequest)request);
            try {
                Dispatcher.setDispatchedPage((ServletRequest)request, contextRelativePath);
                Object oldArgs = request.getAttribute(ARG_MAP_REQUEST_ATTRIBUTE_NAME);
                try {
                    request.setAttribute(ARG_MAP_REQUEST_ATTRIBUTE_NAME, args == null ? null : AoCollections.optimalUnmodifiableMap(args));
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
                finally {
                    request.setAttribute(ARG_MAP_REQUEST_ATTRIBUTE_NAME, oldArgs);
                }
            }
            finally {
                Dispatcher.setDispatchedPage((ServletRequest)request, oldDispatchPage);
            }
        }
        finally {
            if (oldOriginal == null) {
                Dispatcher.setOriginalPage((ServletRequest)request, null);
            }
        }
    }

    public static void forward(ServletContext servletContext, String page, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Dispatcher.forward(servletContext, page, request, response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void include(ServletContext servletContext, String page, HttpServletRequest request, HttpServletResponse response, Map<String, ?> args) throws SkipPageException, ServletException, IOException {
        RequestDispatcher dispatcher;
        String currentPagePath = Dispatcher.getCurrentPagePath(request);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "request={0}, currentPagePath={1}", new Object[]{request, currentPagePath});
        }
        String contextRelativePath = ServletUtil.getAbsolutePath(currentPagePath, page);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "request={0}, contextRelativePath={1}", new Object[]{request, contextRelativePath});
        }
        if ((dispatcher = servletContext.getRequestDispatcher(contextRelativePath)) == null) {
            throw new LocalizedServletException(ApplicationResources.accessor, "Dispatcher.dispatcherNotFound", new Serializable[]{contextRelativePath});
        }
        String oldOriginal = Dispatcher.getOriginalPage((ServletRequest)request);
        try {
            if (oldOriginal == null) {
                String servletPath = request.getServletPath();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "request={0}, servletPath={1}", new Object[]{request, servletPath});
                }
                Dispatcher.setOriginalPage((ServletRequest)request, servletPath);
            }
            String oldDispatchPage = Dispatcher.getDispatchedPage((ServletRequest)request);
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "request={0}, oldDispatchPage={1}", new Object[]{request, oldDispatchPage});
                }
                Dispatcher.setDispatchedPage((ServletRequest)request, contextRelativePath);
                Object oldArgs = request.getAttribute(ARG_MAP_REQUEST_ATTRIBUTE_NAME);
                try {
                    request.setAttribute(ARG_MAP_REQUEST_ATTRIBUTE_NAME, args == null ? null : AoCollections.optimalUnmodifiableMap(args));
                    Includer.dispatchInclude(dispatcher, request, response);
                }
                finally {
                    request.setAttribute(ARG_MAP_REQUEST_ATTRIBUTE_NAME, oldArgs);
                }
            }
            finally {
                Dispatcher.setDispatchedPage((ServletRequest)request, oldDispatchPage);
            }
        }
        finally {
            if (oldOriginal == null) {
                Dispatcher.setOriginalPage((ServletRequest)request, null);
            }
        }
    }

    public static void include(ServletContext servletContext, String page, HttpServletRequest request, HttpServletResponse response) throws SkipPageException, ServletException, IOException {
        Dispatcher.include(servletContext, page, request, response, null);
    }
}

