/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.http;

import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class Cookies {
    private static final Logger logger = Logger.getLogger(Cookies.class.getName());

    private Cookies() {
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String value, String comment, int maxAge, boolean secure, boolean contextOnlyPath) {
        Cookie newCookie = new Cookie(cookieName, value);
        if (comment != null) {
            newCookie.setComment(comment);
        }
        newCookie.setMaxAge(maxAge);
        newCookie.setSecure(secure && request.isSecure());
        String path = contextOnlyPath ? request.getContextPath() + "/" : "/";
        newCookie.setPath(path);
        response.addCookie(newCookie);
    }

    public static String getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int c = cookies.length - 1; c >= 0; --c) {
                Cookie cookie = cookies[c];
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, boolean secure, boolean contextOnlyPath) {
        Cookies.addCookie(request, response, cookieName, "Removed", null, 0, secure, contextOnlyPath);
    }
}

