/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet;

import com.aoindustries.cache.BackgroundCache;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public final class ServletContextCache {
    private static final Logger logger = Logger.getLogger(ServletContextCache.class.getName());
    private static final long REFRESH_INTERVAL = 5000L;
    private static final long EXPIRATION_AGE = 60000L;
    static final String ATTRIBUTE_KEY = ServletContextCache.class.getName();
    private final ServletContext servletContext;
    private final BackgroundCache<String, URL, MalformedURLException> getResourceCache = new BackgroundCache(ServletContextCache.class.getName() + ".getResource", MalformedURLException.class, 5000L, 60000L, logger);
    private final BackgroundCache.Refresher<String, URL, MalformedURLException> getResourceRefresher = new BackgroundCache.Refresher<String, URL, MalformedURLException>(){

        @Override
        public URL call(String path) throws MalformedURLException {
            return ServletContextCache.this.servletContext.getResource(path);
        }
    };
    private final BackgroundCache<String, String, RuntimeException> getRealPathCache = new BackgroundCache(ServletContextCache.class.getName() + ".getRealPath", RuntimeException.class, 5000L, 60000L, logger);
    private final BackgroundCache.Refresher<String, String, RuntimeException> getRealPathRefresher = new BackgroundCache.Refresher<String, String, RuntimeException>(){

        @Override
        public String call(String path) {
            return ServletContextCache.this.servletContext.getRealPath(path);
        }
    };

    public static ServletContextCache getCache(ServletContext servletContext) {
        ServletContextCache cache = (ServletContextCache)servletContext.getAttribute(ATTRIBUTE_KEY);
        if (cache == null) {
            throw new IllegalStateException("ServletContextCache not active in the provided ServletContext.  Add context listener to web.xml?");
        }
        assert (cache.servletContext == servletContext);
        return cache;
    }

    ServletContextCache(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    void stop() {
        this.getResourceCache.stop();
        this.getRealPathCache.stop();
    }

    public URL getResource(String path) throws MalformedURLException {
        BackgroundCache.Result<URL, MalformedURLException> result = this.getResourceCache.get(path, this.getResourceRefresher);
        MalformedURLException exception = result.getException();
        if (exception != null) {
            throw exception;
        }
        return result.getValue();
    }

    public static URL getResource(ServletContext servletContext, String path) throws MalformedURLException {
        return ServletContextCache.getCache(servletContext).getResource(path);
    }

    public String getRealPath(String path) {
        BackgroundCache.Result<String, RuntimeException> result = this.getRealPathCache.get(path, this.getRealPathRefresher);
        RuntimeException exception = result.getException();
        if (exception != null) {
            throw exception;
        }
        return result.getValue();
    }

    public static String getRealPath(ServletContext servletContext, String path) {
        return ServletContextCache.getCache(servletContext).getRealPath(path);
    }
}

