/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.security;

import com.aoindustries.util.WrappedException;
import com.aoindustries.util.persistent.PersistentCollections;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public class HashedKey
implements Comparable<HashedKey> {
    public static final String ALGORITHM = "SHA-256";
    public static final int HASH_BYTES = 32;
    private static final SecureRandom secureRandom = new SecureRandom();
    private final byte[] hash;

    public static byte[] generateKey() {
        byte[] key = new byte[32];
        secureRandom.nextBytes(key);
        return key;
    }

    public static byte[] hash(byte[] key) {
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            md.update(key);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new WrappedException(e);
        }
    }

    public HashedKey(byte[] hash) {
        if (hash.length != 32) {
            Arrays.fill(hash, (byte)0);
            throw new IllegalArgumentException("Hash wrong length: " + hash.length);
        }
        this.hash = Arrays.copyOf(hash, hash.length);
        Arrays.fill(hash, (byte)0);
    }

    public String toString() {
        return "*";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HashedKey)) {
            return false;
        }
        HashedKey other = (HashedKey)obj;
        return Arrays.equals(this.hash, other.hash);
    }

    public int hashCode() {
        return PersistentCollections.bufferToInt(this.hash);
    }

    @Override
    public int compareTo(HashedKey other) {
        byte[] h1 = this.hash;
        byte[] h2 = other.hash;
        for (int i = 0; i < 32; ++i) {
            byte b1 = h1[i];
            byte b2 = h2[i];
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    }
}

