/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.net;

import com.aoindustries.lang.NullArgumentException;
import com.aoindustries.net.MutableHttpParameters;
import com.aoindustries.util.StringUtility;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpParametersMap
implements MutableHttpParameters {
    private final Map<String, List<String>> map = new TreeMap<String, List<String>>();
    private final Map<String, List<String>> unmodifiableMap = Collections.unmodifiableMap(this.map);

    public HttpParametersMap() {
    }

    public HttpParametersMap(String parameters, String encoding) throws UnsupportedEncodingException {
        this.init(parameters, encoding);
    }

    private void init(String parameters, String encoding) throws UnsupportedEncodingException {
        for (String nameValue : StringUtility.splitString(parameters, '&')) {
            String value;
            String name;
            int pos = nameValue.indexOf(61);
            if (pos == -1) {
                name = URLDecoder.decode(nameValue, encoding);
                value = "";
            } else {
                name = URLDecoder.decode(nameValue.substring(0, pos), encoding);
                value = URLDecoder.decode(nameValue.substring(pos + 1), encoding);
            }
            this.addParameter(name, value);
        }
    }

    @Override
    public String getParameter(String name) {
        List<String> values = this.map.get(name);
        if (values == null) {
            return null;
        }
        assert (!values.isEmpty());
        return values.get(0);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this.unmodifiableMap.keySet().iterator();
    }

    @Override
    public List<String> getParameterValues(String name) {
        return this.unmodifiableMap.get(name);
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.unmodifiableMap;
    }

    @Override
    public void addParameter(String name, String value) {
        NullArgumentException.checkNotNull(name, "name");
        NullArgumentException.checkNotNull(value, "value");
        List<String> values = this.map.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.map.put(name, values);
        }
        values.add(value);
    }
}

