/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.md5;

import com.aoindustries.md5.MD5InputStream;
import com.aoindustries.util.BufferManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class MD5Utils {
    private MD5Utils() {
    }

    public static byte[] md5(String filename) throws IOException {
        return MD5Utils.md5(new File(filename));
    }

    public static byte[] md5(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] byArray = MD5Utils.md5(in);
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static byte[] md5(InputStream in) throws IOException {
        MD5InputStream md5in = new MD5InputStream(in);
        byte[] trashBuffer = BufferManager.getBytes();
        try {
            while (md5in.read(trashBuffer, 0, 4096) != -1) {
            }
        }
        finally {
            BufferManager.release(trashBuffer, false);
        }
        return md5in.hash();
    }
}

