/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.util.BufferManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class WriterOutputStream
extends OutputStream {
    private final Writer out;
    private char[] buff = BufferManager.getChars();

    public WriterOutputStream(Writer out) {
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        WriterOutputStream writerOutputStream = this;
        synchronized (writerOutputStream) {
            this.out.close();
            if (this.buff != null) {
                BufferManager.release(this.buff, false);
                this.buff = null;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        WriterOutputStream writerOutputStream = this;
        synchronized (writerOutputStream) {
            if (b == null) {
                throw new NullPointerException();
            }
            int pos = 0;
            while (pos < len) {
                int blockSize = len - pos;
                if (blockSize > 4096) {
                    blockSize = 4096;
                }
                for (int cpos = 0; cpos < blockSize; ++cpos) {
                    this.buff[cpos] = (char)b[off + pos++];
                }
                this.out.write(this.buff, 0, blockSize);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }
}

