/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.TempFile;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class TempFileList {
    private final List<WeakReference<TempFile>> tempFiles = new ArrayList<WeakReference<TempFile>>();
    private final String prefix;
    private final String suffix;
    private final File directory;

    public TempFileList(String prefix) throws IOException {
        this(prefix, null, null);
    }

    public TempFileList(String prefix, String suffix) throws IOException {
        this(prefix, suffix, null);
    }

    public TempFileList(String prefix, String suffix, File directory) throws IOException {
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.directory == null ? 0 : this.directory.getPath().length() + 1 + this.prefix.length() + 1 + this.suffix.length());
        if (this.directory != null) {
            sb.append(this.directory.getPath()).append(File.separatorChar);
        }
        sb.append(this.prefix).append('*').append(this.suffix);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFile createTempFile() throws IOException {
        TempFile tempFile = new TempFile(this.prefix, this.suffix, this.directory);
        List<WeakReference<TempFile>> list = this.tempFiles;
        synchronized (list) {
            this.tempFiles.add(new WeakReference<TempFile>(tempFile));
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        List<WeakReference<TempFile>> list = this.tempFiles;
        synchronized (list) {
            for (WeakReference<TempFile> tempFileRef : this.tempFiles) {
                TempFile tempFile = (TempFile)tempFileRef.get();
                if (tempFile == null) continue;
                tempFile.delete();
            }
            this.tempFiles.clear();
        }
    }
}

