/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PaddingOutputStream
extends FilterOutputStream {
    private final int blockSize;
    private final byte padding;
    private long byteCount = 0L;

    public PaddingOutputStream(OutputStream out, int blockSize, byte padding) {
        super(out);
        this.blockSize = blockSize;
        this.padding = padding;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.byteCount;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.byteCount += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.byteCount += (long)len;
    }

    public void finish() throws IOException {
        int lastBlockSize = (int)(this.byteCount % (long)this.blockSize);
        if (lastBlockSize != 0) {
            while (lastBlockSize < this.blockSize) {
                this.out.write(this.padding);
                ++this.byteCount;
                ++lastBlockSize;
            }
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.close();
    }
}

