/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;

public class LoggingProxy {
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");

    private LoggingProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(File logFile, long connectionId, char separator, String line) {
        File file = logFile;
        synchronized (file) {
            try {
                FileWriter out = new FileWriter(logFile, true);
                try {
                    out.write(Long.toString(connectionId));
                    ((Writer)out).write(separator);
                    ((Writer)out).write(32);
                    out.write(line);
                    ((Writer)out).write(10);
                }
                finally {
                    ((Writer)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 5) {
            try {
                int listenPort = Integer.parseInt(args[1]);
                int connectPort = Integer.parseInt(args[3]);
                long connectionId = 1L;
                while (true) {
                    try {
                        InetAddress listenAddress = InetAddress.getByName(args[0]);
                        InetAddress connectAddress = InetAddress.getByName(args[2]);
                        File logFile = new File(args[4]);
                        ServerSocket ss = new ServerSocket(listenPort, 50, listenAddress);
                        try {
                            while (true) {
                                Socket socketIn = ss.accept();
                                new LoggingProxyThread(socketIn, connectionId++, connectAddress, connectPort, logFile).start();
                            }
                        }
                        catch (Throwable throwable) {
                            ss.close();
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace(System.err);
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
                System.exit(2);
            }
        } else {
            System.err.println("Usage: " + LoggingProxy.class.getName() + "listen_address listen_port connect_address connect_port log_file");
            System.exit(1);
        }
    }

    private static class ReadLogWriteThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;
        private final long connectionId;
        private final char separator;
        private final File logFile;

        ReadLogWriteThread(InputStream in, OutputStream out, long connectionId, char separator, File logFile) {
            this.in = in;
            this.out = out;
            this.connectionId = connectionId;
            this.separator = separator;
            this.logFile = logFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    try {
                        int numBytes;
                        byte[] buff = new byte[4096];
                        while ((numBytes = this.in.read(buff, 0, 4096)) != -1) {
                            LoggingProxy.log(this.logFile, this.connectionId, this.separator, new String(buff, 0, numBytes, CHARSET));
                            this.out.write(buff, 0, numBytes);
                            this.out.flush();
                        }
                    }
                    finally {
                        this.out.close();
                    }
                }
                finally {
                    this.in.close();
                }
            }
            catch (IOException e) {
                LoggingProxy.log(this.logFile, this.connectionId, this.separator, "IOException: " + e.toString());
            }
        }
    }

    private static class LoggingProxyThread
    extends Thread {
        private final Socket socketIn;
        private final long connectionId;
        private final InetAddress connectAddress;
        private final int connectPort;
        private final File logFile;

        private LoggingProxyThread(Socket socketIn, long connectionId, InetAddress connectAddress, int connectPort, File logFile) {
            this.socketIn = socketIn;
            this.connectionId = connectionId;
            this.connectAddress = connectAddress;
            this.connectPort = connectPort;
            this.logFile = logFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    LoggingProxy.log(this.logFile, this.connectionId, ':', "Connection accepted from " + this.socketIn.getRemoteSocketAddress() + ":" + this.socketIn.getPort());
                    LoggingProxy.log(this.logFile, this.connectionId, ':', "Connecting to " + this.connectAddress + ":" + this.connectPort);
                    Socket socketOut = new Socket(this.connectAddress, this.connectPort);
                    try {
                        ReadLogWriteThread inThread = new ReadLogWriteThread(this.socketIn.getInputStream(), socketOut.getOutputStream(), this.connectionId, '<', this.logFile);
                        try {
                            inThread.start();
                            ReadLogWriteThread outThread = new ReadLogWriteThread(socketOut.getInputStream(), this.socketIn.getOutputStream(), this.connectionId, '>', this.logFile);
                            try {
                                outThread.start();
                            }
                            finally {
                                try {
                                    inThread.join();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace(System.err);
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        finally {
                            try {
                                inThread.join();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace(System.err);
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    finally {
                        socketOut.close();
                    }
                }
                finally {
                    this.socketIn.close();
                }
            }
            catch (IOException e) {
                LoggingProxy.log(this.logFile, this.connectionId, ':', "IOException: " + e.toString());
            }
        }
    }
}

