/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;

public class LogFollower
extends InputStream {
    public static final int DEFAULT_POLL_INTERVAL = 60000;
    private final int pollInterval;
    private final File file;
    private volatile boolean closed;
    private final FilePosLock filePosLock = new FilePosLock();
    private long filePos;

    public LogFollower(String path) {
        this(new File(path), 60000);
    }

    public LogFollower(File file) {
        this(file, 60000);
    }

    public LogFollower(String path, int pollInterval) {
        this(new File(path), pollInterval);
    }

    public LogFollower(File file, int pollInterval) {
        this.pollInterval = pollInterval;
        this.file = file;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("LogFollower has been closed: " + this.file.getPath());
        }
    }

    private void detectFileChange() throws IOException {
        this.checkClosed();
        assert (Thread.holdsLock(this.filePosLock));
        while (!this.file.exists()) {
            try {
                System.err.println("File not found, waiting: " + this.file.getPath());
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                InterruptedIOException newExc = new InterruptedIOException(e.getMessage());
                newExc.initCause(e);
                throw newExc;
            }
            this.checkClosed();
        }
        long fileLen = this.file.length();
        if (fileLen < this.filePos) {
            this.filePos = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        this.checkClosed();
        FilePosLock filePosLock = this.filePosLock;
        synchronized (filePosLock) {
            this.detectFileChange();
            long available = this.file.length() - this.filePos;
            if (available < 0L) {
                available = 0L;
            } else if (available > Integer.MAX_VALUE) {
                available = Integer.MAX_VALUE;
            }
            return (int)available;
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        this.checkClosed();
        while (true) {
            FilePosLock filePosLock = this.filePosLock;
            synchronized (filePosLock) {
                this.detectFileChange();
                long ral = this.file.length();
                if (ral > this.filePos) {
                    RandomAccessFile randomAccess = new RandomAccessFile(this.file, "r");
                    try {
                        randomAccess.seek(this.filePos++);
                        int n = randomAccess.read();
                        return n;
                    }
                    finally {
                        randomAccess.close();
                    }
                }
            }
            try {
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                InterruptedIOException ioErr = new InterruptedIOException();
                ioErr.initCause(err);
                throw ioErr;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        this.checkClosed();
        while (true) {
            FilePosLock filePosLock = this.filePosLock;
            synchronized (filePosLock) {
                this.detectFileChange();
                long ral = this.file.length();
                if (ral > this.filePos) {
                    RandomAccessFile randomAccess = new RandomAccessFile(this.file, "r");
                    try {
                        randomAccess.seek(this.filePos);
                        long avail = randomAccess.length() - this.filePos;
                        if (avail > (long)len) {
                            avail = len;
                        }
                        int actual = randomAccess.read(b, offset, (int)avail);
                        this.filePos += (long)actual;
                        int n = actual;
                        return n;
                    }
                    finally {
                        randomAccess.close();
                    }
                }
            }
            try {
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                InterruptedIOException ioErr = new InterruptedIOException();
                ioErr.initCause(err);
                throw ioErr;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        while (true) {
            FilePosLock filePosLock = this.filePosLock;
            synchronized (filePosLock) {
                this.detectFileChange();
                long ral = this.file.length();
                if (ral > this.filePos) {
                    RandomAccessFile randomAccess = new RandomAccessFile(this.file, "r");
                    try {
                        randomAccess.seek(this.filePos);
                        long avail = randomAccess.length() - this.filePos;
                        if (avail > n) {
                            avail = n;
                        }
                        int actual = randomAccess.skipBytes((int)avail);
                        this.filePos += (long)actual;
                        long l = actual;
                        return l;
                    }
                    finally {
                        randomAccess.close();
                    }
                }
            }
            try {
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                InterruptedIOException ioErr = new InterruptedIOException();
                ioErr.initCause(err);
                throw ioErr;
            }
        }
    }

    private static class FilePosLock {
        private FilePosLock() {
        }
    }
}

