/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.FilesystemIteratorRule;
import com.aoindustries.util.AoArrays;
import com.aoindustries.util.WrappedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;

public class FilesystemIterator
implements Comparable<FilesystemIterator> {
    private final Map<String, FilesystemIteratorRule> rules;
    private final Map<String, FilesystemIteratorRule> prefixRules;
    private final String startPath;
    private final boolean isPreorder;
    private final boolean isSorted;
    private Stack<String> currentDirectories;
    private Stack<String[]> currentLists;
    private Stack<Integer> currentIndexes;
    private boolean filesDone = false;

    public FilesystemIterator(Map<String, FilesystemIteratorRule> rules, Map<String, FilesystemIteratorRule> prefixRules) {
        this(rules, prefixRules, "", true, true);
    }

    public FilesystemIterator(Map<String, FilesystemIteratorRule> rules, Map<String, FilesystemIteratorRule> prefixRules, boolean isPreorder, boolean isSorted) {
        this(rules, prefixRules, "", isPreorder, isSorted);
    }

    public FilesystemIterator(Map<String, FilesystemIteratorRule> rules, Map<String, FilesystemIteratorRule> prefixRules, String startPath) {
        this(rules, prefixRules, startPath, true, true);
    }

    public FilesystemIterator(Map<String, FilesystemIteratorRule> rules, Map<String, FilesystemIteratorRule> prefixRules, String startPath, boolean isPreorder, boolean isSorted) {
        this.rules = rules;
        this.prefixRules = prefixRules;
        this.currentDirectories = null;
        this.currentLists = null;
        this.currentIndexes = null;
        this.filesDone = false;
        this.startPath = startPath;
        this.isPreorder = isPreorder;
        this.isSorted = isSorted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getNextFile() throws IOException {
        FilesystemIterator filesystemIterator = this;
        synchronized (filesystemIterator) {
            while (!this.filesDone) {
                String currentDirectory;
                if (this.currentDirectories == null) {
                    if (this.startPath.length() == 0) {
                        this.currentDirectories = new Stack<String>();
                        this.currentDirectories.push("");
                        this.currentLists = new Stack<String[]>();
                        this.currentLists.push(this.getFilesystemRoots());
                    } else if (this.isFilesystemRoot(this.startPath)) {
                        this.currentDirectories = new Stack<String>();
                        this.currentDirectories.push("");
                        this.currentLists = new Stack<String[]>();
                        this.currentLists.push(new String[]{this.startPath});
                    } else {
                        File startPathFile = new File(this.startPath);
                        String parent = startPathFile.getParent();
                        String name = startPathFile.getName();
                        this.currentDirectories = new Stack<String>();
                        this.currentDirectories.push(parent);
                        this.currentLists = new Stack<String[]>();
                        this.currentLists.push(new String[]{name});
                    }
                    this.currentIndexes = new Stack<Integer>();
                    this.currentIndexes.push(0);
                }
                String[] currentList = null;
                int currentIndex = -1;
                try {
                    currentDirectory = this.currentDirectories.peek();
                    currentList = this.currentLists.peek();
                    currentIndex = this.currentIndexes.peek();
                    while (currentDirectory != null && currentIndex >= currentList.length) {
                        this.currentDirectories.pop();
                        this.currentLists.pop();
                        this.currentIndexes.pop();
                        String oldCurrentDirectory = currentDirectory;
                        currentDirectory = this.currentDirectories.peek();
                        currentList = this.currentLists.peek();
                        currentIndex = this.currentIndexes.peek();
                        if (this.isPreorder) continue;
                        return new File(oldCurrentDirectory);
                    }
                }
                catch (EmptyStackException err) {
                    currentDirectory = null;
                }
                if (currentDirectory == null) {
                    this.filesDone = true;
                    return null;
                }
                String filename = currentDirectory.length() == 0 ? currentList[currentIndex] : (currentDirectory.endsWith(File.separator) ? currentDirectory + currentList[currentIndex] : currentDirectory + File.separatorChar + currentList[currentIndex]);
                this.currentIndexes.pop();
                this.currentIndexes.push(currentIndex + 1);
                try {
                    File file;
                    block24: {
                        boolean recurse;
                        block25: {
                            Object[] list;
                            block28: {
                                block26: {
                                    block27: {
                                        boolean includeDirectory;
                                        file = new File(filename);
                                        if (!file.isDirectory()) break block24;
                                        String filenamePlusSlash = filename.endsWith(File.separator) ? filename : filename + File.separatorChar;
                                        if (this.isIncluded(filename)) {
                                            includeDirectory = true;
                                            FilesystemIteratorRule rule = this.rules.get(filenamePlusSlash);
                                            recurse = rule == null ? true : (rule.isIncluded(filenamePlusSlash) ? true : this.hasIncludedChild(filenamePlusSlash));
                                        } else if (this.hasIncludedChild(filenamePlusSlash)) {
                                            includeDirectory = true;
                                            recurse = true;
                                        } else {
                                            includeDirectory = false;
                                            recurse = false;
                                        }
                                        if (!includeDirectory) break block25;
                                        if (!recurse) break block26;
                                        if (!file.getCanonicalPath().equals(filename)) break block27;
                                        list = file.list();
                                        if (list == null) {
                                            list = AoArrays.EMPTY_STRING_ARRAY;
                                            break block28;
                                        } else if (this.isSorted && list.length > 0) {
                                            Arrays.sort(list);
                                        }
                                        break block28;
                                    }
                                    list = AoArrays.EMPTY_STRING_ARRAY;
                                    break block28;
                                }
                                list = AoArrays.EMPTY_STRING_ARRAY;
                            }
                            if (list.length <= 0) {
                                return file;
                            }
                            this.currentDirectories.push(filename);
                            this.currentLists.push((String[])list);
                            this.currentIndexes.push(0);
                            if (!this.isPreorder) continue;
                            return file;
                        }
                        if (recurse) {
                            throw new AssertionError((Object)"recurse=true and includeDirectory=false");
                        }
                        continue;
                    }
                    if (!this.isIncluded(filename)) continue;
                    return file;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    continue;
                }
                break;
            }
            return null;
        }
    }

    public int getNextFiles(File[] files, int batchSize) throws IOException {
        File file;
        int c = 0;
        while (c < batchSize && (file = this.getNextFile()) != null) {
            files[c++] = file;
        }
        return c;
    }

    protected String[] getFilesystemRoots() throws IOException {
        File[] fileRoots = File.listRoots();
        ArrayList<String> tempRoots = new ArrayList<String>(fileRoots.length);
        for (File fileRoot : fileRoots) {
            String root = fileRoot.getPath();
            FilesystemIteratorRule defaultRule = this.rules.get("");
            if ((defaultRule == null || !defaultRule.isIncluded(root)) && !this.hasIncludedChild(root)) continue;
            tempRoots.add(root);
        }
        return tempRoots.toArray(new String[tempRoots.size()]);
    }

    protected boolean isFilesystemRoot(String filename) throws IOException {
        String[] roots = this.getFilesystemRoots();
        int len = roots.length;
        for (int c = 0; c < len; ++c) {
            if (!roots[c].equals(filename)) continue;
            return true;
        }
        return false;
    }

    private FilesystemIteratorRule getBestRule(String filename) {
        String longestPrefix = null;
        FilesystemIteratorRule rule = null;
        String path = filename;
        while (true) {
            if ((rule = this.rules.get(path)) != null) {
                longestPrefix = path;
                break;
            }
            int pathLen = path.length();
            if (pathLen == 0) break;
            int lastSlashPos = path.lastIndexOf(File.separatorChar);
            if (lastSlashPos == -1) {
                path = "";
                continue;
            }
            if (lastSlashPos == pathLen - 1) {
                path = path.substring(0, lastSlashPos);
                continue;
            }
            path = path.substring(0, lastSlashPos + 1);
        }
        if (this.prefixRules != null) {
            for (Map.Entry<String, FilesystemIteratorRule> entry : this.prefixRules.entrySet()) {
                String prefix = entry.getKey();
                if (longestPrefix != null && prefix.length() <= longestPrefix.length() || !filename.startsWith(prefix)) continue;
                longestPrefix = prefix;
                rule = entry.getValue();
            }
        }
        return rule;
    }

    private boolean isIncluded(String filename) throws IOException {
        FilesystemIteratorRule rule = this.getBestRule(filename);
        if (rule != null) {
            return rule.isIncluded(filename);
        }
        return false;
    }

    private boolean hasIncludedChild(String filenamePlusSlash) throws IOException {
        FilesystemIteratorRule rule;
        String path;
        for (Map.Entry<String, FilesystemIteratorRule> entry : this.rules.entrySet()) {
            path = entry.getKey();
            if (!path.startsWith(filenamePlusSlash) || !(rule = entry.getValue()).isIncluded(filenamePlusSlash)) continue;
            return true;
        }
        for (Map.Entry<String, FilesystemIteratorRule> entry : this.prefixRules.entrySet()) {
            path = entry.getKey();
            rule = entry.getValue();
            if (!path.startsWith(filenamePlusSlash) || !rule.isIncluded(filenamePlusSlash)) continue;
            return true;
        }
        return false;
    }

    public Iterator<String> getFilenameIterator() throws IOException {
        return new FilenameIterator(this);
    }

    public String getStartPath() {
        return this.startPath;
    }

    public boolean isPreorder() {
        return this.isPreorder;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    @Override
    public int compareTo(FilesystemIterator other) {
        return this.startPath.compareTo(other.startPath);
    }

    static class FilenameIterator
    implements Iterator<String> {
        private final FilesystemIterator filesystemIterator;
        File next;

        FilenameIterator(FilesystemIterator filesystemIterator) throws IOException {
            this.filesystemIterator = filesystemIterator;
            this.next = filesystemIterator.getNextFile();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            try {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                String retVal = this.next.getPath();
                this.next = this.filesystemIterator.getNextFile();
                return retVal;
            }
            catch (IOException err) {
                throw new WrappedException(err);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

