/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.FilesystemIteratorRule;
import java.io.File;
import java.io.IOException;

public class FileExistsRule
implements FilesystemIteratorRule {
    private final String[] fullPaths;
    private final FilesystemIteratorRule existsRule;
    private final FilesystemIteratorRule notExistsRule;

    public FileExistsRule(String[] fullPaths, FilesystemIteratorRule existsRule, FilesystemIteratorRule notExistsRule) {
        this.fullPaths = fullPaths;
        this.existsRule = existsRule;
        this.notExistsRule = notExistsRule;
    }

    public FilesystemIteratorRule getEffectiveRule(String filename) throws IOException {
        for (String fullPath : this.fullPaths) {
            File file = new File(fullPath);
            if (!file.exists()) continue;
            return this.existsRule;
        }
        return this.notExistsRule;
    }

    @Override
    public boolean isIncluded(String filename) throws IOException {
        return this.getEffectiveRule(filename).isIncluded(filename);
    }
}

