/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.FifoFile;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class FifoFileOutputStream
extends OutputStream {
    private final FifoFile file;
    private final StatsLock statsLock = new StatsLock();
    private long fifoWriteCount = 0L;
    private long fifoWriteBytes = 0L;

    FifoFileOutputStream(FifoFile file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteCount() {
        StatsLock statsLock = this.statsLock;
        synchronized (statsLock) {
            return this.fifoWriteCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteBytes() {
        StatsLock statsLock = this.statsLock;
        synchronized (statsLock) {
            return this.fifoWriteBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStats(long bytes) {
        StatsLock statsLock = this.statsLock;
        synchronized (statsLock) {
            ++this.fifoWriteCount;
            this.fifoWriteBytes += bytes;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(int b) throws IOException {
        FifoFile fifoFile = this.file;
        synchronized (fifoFile) {
            while (true) {
                long len;
                if ((len = this.file.getLength()) < this.file.maxFifoLength) {
                    long pos = this.file.getFirstIndex() + len;
                    while (true) {
                        if (pos < this.file.maxFifoLength) {
                            this.file.file.seek(pos + 16L);
                            this.file.file.write(b);
                            this.addStats(1L);
                            this.file.setLength(len + 1L);
                            this.file.notify();
                            return;
                        }
                        pos -= this.file.maxFifoLength;
                    }
                }
                try {
                    this.file.wait();
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err);
                    throw ioErr;
                }
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            FifoFile fifoFile = this.file;
            synchronized (fifoFile) {
                while (true) {
                    long fileLen;
                    long maxBlockSize;
                    if ((maxBlockSize = this.file.maxFifoLength - (fileLen = this.file.getLength())) > 0L) {
                        int blockSize;
                        long pos;
                        for (pos = this.file.getFirstIndex() + fileLen; pos >= this.file.maxFifoLength; pos -= this.file.maxFifoLength) {
                        }
                        int n = blockSize = maxBlockSize > (long)len ? len : (int)maxBlockSize;
                        if (pos + (long)blockSize > this.file.maxFifoLength) {
                            blockSize = (int)(this.file.maxFifoLength - pos);
                        }
                        this.file.file.seek(pos + 16L);
                        this.file.file.write(b, off, blockSize);
                        this.addStats(blockSize);
                        this.file.setLength(fileLen + (long)blockSize);
                        off += blockSize;
                        len -= blockSize;
                        break;
                    }
                    try {
                        this.file.wait();
                    }
                    catch (InterruptedException err) {
                        Thread.currentThread().interrupt();
                        InterruptedIOException ioErr = new InterruptedIOException();
                        ioErr.initCause(err);
                        throw ioErr;
                    }
                }
                this.file.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        FifoFile fifoFile = this.file;
        synchronized (fifoFile) {
            this.file.file.getChannel().force(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long available() throws IOException {
        FifoFile fifoFile = this.file;
        synchronized (fifoFile) {
            return this.file.maxFifoLength - this.file.getLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        FifoFile fifoFile = this.file;
        synchronized (fifoFile) {
            this.file.close();
        }
    }

    private static class StatsLock {
        private StatsLock() {
        }
    }
}

