/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.FifoFile;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class FifoFileInputStream
extends InputStream {
    private final FifoFile file;
    private final StatsLock statsLock = new StatsLock();
    private long fifoReadCount = 0L;
    private long fifoReadBytes = 0L;

    FifoFileInputStream(FifoFile file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReadCount() {
        StatsLock statsLock = this.statsLock;
        synchronized (statsLock) {
            return this.fifoReadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReadBytes() {
        StatsLock statsLock = this.statsLock;
        synchronized (statsLock) {
            return this.fifoReadBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStats(long bytes) {
        StatsLock statsLock = this.statsLock;
        synchronized (statsLock) {
            ++this.fifoReadCount;
            this.fifoReadBytes += bytes;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        FifoFile fifoFile = this.file;
        synchronized (fifoFile) {
            while (true) {
                long len;
                if ((len = this.file.getLength()) >= 1L) {
                    long pos = this.file.getFirstIndex();
                    this.file.file.seek(pos + 16L);
                    int b = this.file.file.read();
                    if (b == -1) {
                        throw new EOFException("Unexpected EOF");
                    }
                    this.addStats(1L);
                    long newFirstIndex = pos + 1L;
                    while (true) {
                        if (newFirstIndex < this.file.maxFifoLength) {
                            this.file.setFirstIndex(newFirstIndex);
                            this.file.setLength(len - 1L);
                            this.file.notify();
                            return b;
                        }
                        newFirstIndex -= this.file.maxFifoLength;
                    }
                }
                try {
                    this.file.wait();
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err);
                    throw ioErr;
                }
            }
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        FifoFile fifoFile = this.file;
        synchronized (fifoFile) {
            while (true) {
                long fileLen;
                if ((fileLen = this.file.getLength()) >= 1L) {
                    int totalRead;
                    int readSize;
                    long pos = this.file.getFirstIndex();
                    this.file.file.seek(pos + 16L);
                    int n = readSize = fileLen > (long)len ? len : (int)fileLen;
                    if (pos + (long)readSize > this.file.maxFifoLength) {
                        readSize = (int)(this.file.maxFifoLength - pos);
                    }
                    if ((totalRead = this.file.file.read(b, off, readSize)) == -1) {
                        throw new EOFException("Unexpected EOF");
                    }
                    this.addStats(totalRead);
                    long newFirstIndex = pos + (long)totalRead;
                    while (true) {
                        if (newFirstIndex < this.file.maxFifoLength) {
                            this.file.setFirstIndex(newFirstIndex);
                            this.file.setLength(fileLen - (long)totalRead);
                            this.file.notify();
                            return totalRead;
                        }
                        newFirstIndex -= this.file.maxFifoLength;
                    }
                }
                try {
                    this.file.wait();
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err);
                    throw ioErr;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long skip(long n) throws IOException {
        FifoFile fifoFile = this.file;
        synchronized (fifoFile) {
            while (true) {
                long fileLen;
                if ((fileLen = this.file.getLength()) >= 1L) {
                    long skipSize;
                    long pos = this.file.getFirstIndex();
                    long l = skipSize = fileLen > n ? n : fileLen;
                    if (pos + skipSize > this.file.maxFifoLength) {
                        skipSize = this.file.maxFifoLength - pos;
                    }
                    long totalSkipped = skipSize;
                    long newFirstIndex = pos + skipSize;
                    while (true) {
                        if (newFirstIndex < this.file.maxFifoLength) {
                            this.file.setFirstIndex(newFirstIndex);
                            this.file.setLength(fileLen - skipSize);
                            this.file.notify();
                            return totalSkipped;
                        }
                        newFirstIndex -= this.file.maxFifoLength;
                    }
                }
                try {
                    this.file.wait();
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err);
                    throw ioErr;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        FifoFile fifoFile = this.file;
        synchronized (fifoFile) {
            long len = this.file.getLength();
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    private static class StatsLock {
        private StatsLock() {
        }
    }
}

