/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.FifoFileInputStream;
import com.aoindustries.io.FifoFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FifoFile {
    final RandomAccessFile file;
    final FifoFileInputStream in;
    final FifoFileOutputStream out;
    final long maxFifoLength;
    final long fileLength;
    final int _blockSize;

    public FifoFile(String filename, long maxFifoLength) throws IOException {
        this(new File(filename), maxFifoLength);
    }

    public FifoFile(File file, long maxFifoLength) throws IOException {
        if (maxFifoLength < 1L) {
            throw new IllegalArgumentException("The FIFO must be at least one byte long");
        }
        this.maxFifoLength = maxFifoLength;
        this.fileLength = maxFifoLength + 16L;
        this.file = new RandomAccessFile(file, "rw");
        this.in = new FifoFileInputStream(this);
        this.out = new FifoFileOutputStream(this);
        long blockSize = maxFifoLength >> 8;
        int n = blockSize >= 4096L ? 4096 : (this._blockSize = blockSize <= 0L ? 1 : (int)blockSize);
        if (this.file.length() != this.fileLength) {
            this.reset();
        }
    }

    public FifoFileInputStream getInputStream() {
        return this.in;
    }

    public FifoFileOutputStream getOutputStream() {
        return this.out;
    }

    public long getMaximumFifoLength() {
        return this.maxFifoLength;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        FifoFile fifoFile = this;
        synchronized (fifoFile) {
            this.file.setLength(this.fileLength);
            this.setLength(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FifoFile fifoFile = this;
        synchronized (fifoFile) {
            this.file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getFirstIndex() throws IOException {
        FifoFile fifoFile = this;
        synchronized (fifoFile) {
            this.file.seek(0L);
            return this.file.readLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFirstIndex(long index) throws IOException {
        FifoFile fifoFile = this;
        synchronized (fifoFile) {
            this.file.seek(0L);
            this.file.writeLong(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() throws IOException {
        FifoFile fifoFile = this;
        synchronized (fifoFile) {
            this.file.seek(8L);
            return this.file.readLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLength(long length) throws IOException {
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        FifoFile fifoFile = this;
        synchronized (fifoFile) {
            this.file.seek(8L);
            this.file.writeLong(length);
            if (length == 0L) {
                this.setFirstIndex(0L);
            }
        }
    }
}

