/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.email;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MimeType {
    public static final String DEFAULT_MIME_TYPE = "unknown/unknown";
    private static final String[] types = new String[]{"aif", "audio/x-aiff", "aifc", "audio/x-aiff", "aiff", "audio/x-aiff", "asc", "text/plain", "au", "audio/basic", "avi", "video/x-msvideo", "bin", "application/octet-stream", "bmp", "image/bmp", "c", "text/plain", "class", "application/octet-stream", "cpio", "application/x-cpio", "csh", "application/x-csh", "css", "text/css", "doc", "application/msword", "dvi", "application/x-dvi", "eps", "application/postscript", "exe", "application/octet-stream", "gif", "image/gif", "gtar", "application/x-gtar", "gz", "application/x-gzip", "h", "text/plain", "html", "text/html", "htm", "text/html", "jad", "text/vnd.sun.j2me.app-descriptor", "jar", "application/java-archive", "java", "text/plain", "jpeg", "image/jpeg", "jpe", "image/jpeg", "jpg", "image/jpeg", "js", "application/x-javascript", "latex", "application/x-latex", "log", "text/plain", "m3u", "audio/x-mpegurl", "man", "application/x-troff-man", "mid", "audio/midi", "midi", "audio/midi", "movie", "video/x-sgi-movie", "mov", "video/quicktime", "mpeg", "video/mpeg", "mpe", "video/mpeg", "mp2", "audio/mpeg", "mp3", "audio/mpeg", "mpga", "audio/mpeg", "mpg", "video/mpeg", "pbm", "image/x-portable-bitmap", "pdf", "application/pdf", "pid", "text/plain", "pgm", "image/x-portable-graymap", "png", "image/png", "pnm", "image/x-portable-anymap", "ppm", "image/x-portable-pixmap", "ppt", "application/vnd.ms-powerpoint", "properties", "text/plain", "ps", "application/postscript", "qt", "video/quicktime", "ra", "audio/x-realaudio", "ram", "audio/x-pn-realaudio", "rar", "application/x-rar-compressed", "ras", "image/x-cmu-raster", "rgb", "image/x-rgb", "rm", "audio/x-pn-realaudio", "rtf", "text/rtf", "rtx", "text/richtext", "sgml", "text/sgml", "sgm", "text/sgml", "sh", "application/x-sh", "sit", "application/x-stuffit", "snd", "audio/basic", "sql", "text/plain", "swf", "application/x-shockwave-flash", "tar", "application/x-tar", "tcl", "application/x-tcl", "tex", "application/x-tex", "texi", "application/x-texinfo", "texinfo", "application/x-texinfo", "tiff", "image/tiff", "tif", "image/tiff", "ts", "text/tab-separated-values", "txt", "text/plain", "vrml", "model/vrml", "wav", "audio/x-wav", "wmlc", "application/vnd.wap.wmlc", "wmlsc", "application/vnd.wap.wmlscriptc", "wmls", "text/vnd.wap.wmlscript", "wml", "text/vnd.wap.wml", "wrl", "model/vrml", "xbm", "image/x-xbitmap", "xls", "application/vnd.ms-excel", "xml", "text/xml", "xpm", "image/x-xpixmap", "xwd", "image/x-xwindowdump", "z", "application/x-compress", "zip", "application/zip"};
    private static final Map<String, String> hash = new HashMap<String, String>();

    private MimeType() {
    }

    public static String getMimeType(String filename) {
        String type;
        int pos = filename.lastIndexOf(46);
        if (pos != -1 && (type = hash.get(filename.substring(pos + 1).toLowerCase(Locale.ROOT))) != null) {
            return type;
        }
        return DEFAULT_MIME_TYPE;
    }

    static {
        for (int c = 0; c < types.length; c += 2) {
            String extension = types[c].toLowerCase(Locale.ROOT);
            if (hash.put(extension, types[c + 1]) != null) {
                throw new AssertionError((Object)(MimeType.class.getName() + ": extension found more than once: " + extension));
            }
        }
    }
}

