/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.servlet.firewall.pathspace;

import com.aoapps.net.Path;
import com.aoapps.net.pathspace.PathMatch;
import com.aoapps.net.pathspace.PathSpace;
import com.aoapps.net.pathspace.Prefix;
import com.aoapps.net.pathspace.PrefixConflictException;
import com.aoapps.servlet.attribute.ScopeEE;
import com.aoapps.servlet.firewall.pathspace.FirewallComponent;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

public class FirewallPathSpace {
    private static final ScopeEE.Application.Attribute<FirewallPathSpace> APPLICATION_ATTRIBUTE = ScopeEE.APPLICATION.attribute(FirewallPathSpace.class.getName());
    private final PathSpace<FirewallComponent> pathSpace = new PathSpace();

    public static FirewallPathSpace getInstance(ServletContext servletContext) {
        return (FirewallPathSpace)APPLICATION_ATTRIBUTE.context(servletContext).computeIfAbsent(__ -> {
            FirewallPathSpace instance = new FirewallPathSpace();
            return instance;
        });
    }

    private FirewallPathSpace() {
    }

    public FirewallPathSpace add(FirewallComponent component) throws PrefixConflictException {
        for (Prefix prefix2 : component.getPrefixes()) {
            this.pathSpace.put(prefix2, (Object)component);
        }
        return this;
    }

    public FirewallPathSpace add(FirewallComponent ... components) throws PrefixConflictException {
        for (FirewallComponent component : components) {
            this.add(component);
        }
        return this;
    }

    public PathMatch<FirewallComponent> get(Path path2) {
        return this.pathSpace.get(path2);
    }

    @WebListener
    public static class Initializer
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent event) {
            FirewallPathSpace.getInstance(event.getServletContext());
        }

        public void contextDestroyed(ServletContextEvent event) {
        }
    }
}

