/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.servlet.firewall.pathspace;

import com.aoapps.collections.AoCollections;
import com.aoapps.net.pathspace.Prefix;
import com.aoapps.servlet.firewall.api.Rule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class FirewallComponent {
    private final Set<Prefix> prefixes;
    private final List<Rule> rules = new CopyOnWriteArrayList<Rule>();
    private final List<Rule> unmodifiableRules = Collections.unmodifiableList(this.rules);
    private final Iterable<Rule> rulesIter = this.rules::iterator;

    public static FirewallComponent newInstance(Iterable<? extends Prefix> prefixes, Iterable<? extends Rule> rules) {
        FirewallComponent component = new FirewallComponent(prefixes);
        component.append(rules);
        return component;
    }

    public static FirewallComponent newInstance(Iterable<? extends Prefix> prefixes, Rule ... rules) {
        return FirewallComponent.newInstance(prefixes, Arrays.asList(rules));
    }

    public static FirewallComponent newInstance(Prefix[] prefixes, Iterable<? extends Rule> rules) {
        return FirewallComponent.newInstance(Arrays.asList(prefixes), rules);
    }

    public static FirewallComponent newInstance(Prefix[] prefixes, Rule ... rules) {
        return FirewallComponent.newInstance(Arrays.asList(prefixes), rules);
    }

    public static FirewallComponent newInstance(Prefix prefix2, Iterable<? extends Rule> rules) {
        return FirewallComponent.newInstance(Collections.singleton(prefix2), rules);
    }

    public static FirewallComponent newInstance(Prefix prefix2, Rule ... rules) {
        return FirewallComponent.newInstance(Collections.singleton(prefix2), rules);
    }

    private FirewallComponent(Iterable<? extends Prefix> prefixes) {
        this.prefixes = AoCollections.unmodifiableCopySet(prefixes);
        if (this.prefixes.isEmpty()) {
            throw new IllegalArgumentException("prefixes is empty");
        }
    }

    public Set<Prefix> getPrefixes() {
        return this.prefixes;
    }

    public List<Rule> getRules() {
        return this.unmodifiableRules;
    }

    public Iterable<Rule> getRulesIterable() {
        return this.rulesIter;
    }

    public void prepend(Iterable<? extends Rule> rules) {
        this.rules.addAll(0, AoCollections.asCollection(rules));
    }

    public void prepend(Rule ... rules) {
        this.prepend(Arrays.asList(rules));
    }

    public void append(Iterable<? extends Rule> rules) {
        this.rules.addAll(AoCollections.asCollection(rules));
    }

    public void append(Rule ... rules) {
        this.append(Arrays.asList(rules));
    }
}

