/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.cron;

import com.aoapps.cron.Matcher;
import com.aoapps.cron.MultiSchedule;
import com.aoapps.cron.Schedule;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MatcherSchedule
implements Schedule {
    private static final Schedule YEARLY = (minute, hour, dayOfMonth, month, dayOfWeek, year) -> minute == 0 && hour == 0 && dayOfMonth == 1 && month == 0;
    private static final Schedule MONTHLY = (minute, hour, dayOfMonth, month, dayOfWeek, year) -> minute == 0 && hour == 0 && dayOfMonth == 1;
    private static final Schedule WEEKLY = (minute, hour, dayOfMonth, month, dayOfWeek, year) -> minute == 0 && hour == 0 && dayOfWeek == 1;
    private static final Schedule DAILY = (minute, hour, dayOfMonth, month, dayOfWeek, year) -> minute == 0 && hour == 0;
    private static final Schedule HOURLY = (minute, hour, dayOfMonth, month, dayOfWeek, year) -> minute == 0;
    private final Matcher minute;
    private final Matcher hour;
    private final Matcher dayOfMonth;
    private final Matcher month;
    private final Matcher dayOfWeek;

    public static Schedule parseSchedule(String str) throws IllegalArgumentException {
        if (str.indexOf(59) != -1) {
            ArrayList<Schedule> schedules = new ArrayList<Schedule>();
            StringTokenizer st = new StringTokenizer(";");
            while (st.hasMoreTokens()) {
                schedules.add(MatcherSchedule.parseSchedule(st.nextToken()));
            }
            return new MultiSchedule(schedules);
        }
        if ("@yearly".equalsIgnoreCase(str) || "@annually".equalsIgnoreCase(str)) {
            return YEARLY;
        }
        if ("@monthly".equalsIgnoreCase(str)) {
            return MONTHLY;
        }
        if ("@weekly".equalsIgnoreCase(str)) {
            return WEEKLY;
        }
        if ("@daily".equalsIgnoreCase(str) || "@midnight".equalsIgnoreCase(str)) {
            return DAILY;
        }
        if ("@hourly".equalsIgnoreCase(str)) {
            return HOURLY;
        }
        StringTokenizer st = new StringTokenizer(str);
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        Matcher minute = Matcher.parseMinute(st.nextToken());
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        Matcher hour = Matcher.parseHour(st.nextToken());
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        Matcher dayOfMonth = Matcher.parseDayOfMonth(st.nextToken());
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        Matcher month = Matcher.parseMonth(st.nextToken());
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        Matcher dayOfWeek = Matcher.parseDayOfWeek(st.nextToken());
        if (st.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        return new MatcherSchedule(minute, hour, dayOfMonth, month, dayOfWeek);
    }

    public MatcherSchedule(Matcher minute, Matcher hour, Matcher dayOfMonth, Matcher month, Matcher dayOfWeek) {
        this.minute = minute;
        this.hour = hour;
        this.dayOfMonth = dayOfMonth;
        this.month = month;
        this.dayOfWeek = dayOfWeek;
    }

    public String toString() {
        return this.minute + " " + this.hour + " " + this.dayOfMonth + " " + this.month + " " + this.dayOfWeek;
    }

    public Matcher getMinute() {
        return this.minute;
    }

    public Matcher getHour() {
        return this.hour;
    }

    public Matcher getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Matcher getMonth() {
        return this.month;
    }

    public Matcher getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public boolean isScheduled(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
        return this.minute.matches(minute) && this.hour.matches(hour) && this.month.matches(1 + (month - 0)) && (this.dayOfMonth.matches(dayOfMonth) || this.dayOfWeek.matches(0 + (dayOfWeek - 1)));
    }
}

