/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.organizations.organizationId.assets.groupId.assetId.version;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.organizations.organizationId.assets.groupId.assetId.version.model.VersionPOSTBody;
import org.mule.exchange.resource.organizations.organizationId.assets.groupId.assetId.version.model.VersionPOSTHeader;
import org.mule.exchange.resource.organizations.organizationId.assets.groupId.assetId.version.model.VersionPOSTResponseBody;
import org.mule.exchange.resource.organizations.organizationId.assets.groupId.assetId.version.publication.Publication;
import org.mule.exchange.responses.ExchangexapiResponse;

public class Version {
    private String _baseUrl;
    private Client _client;
    public final Publication publication;

    public Version() {
        this._baseUrl = null;
        this._client = null;
        this.publication = null;
    }

    public Version(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
        this.publication = new Publication(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<VersionPOSTResponseBody> post(VersionPOSTBody body, VersionPOSTHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXSyncPublication() != null) {
            invocationBuilder.header("x-sync-publication", (Object)headers.getXSyncPublication());
        }
        if (headers.getXAllowedApiSpecFormats() != null) {
            invocationBuilder.header("x-allowed-api-spec-formats", (Object)headers.getXAllowedApiSpecFormats());
        }
        if (headers.getContentType() != null) {
            invocationBuilder.header("Content-Type", (Object)headers.getContentType());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        FormDataMultiPart multiPart = new FormDataMultiPart();
        Response response = invocationBuilder.method("POST", Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity(VersionPOSTResponseBody.class), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

